package com.biz.crm.eunm.activiti;

import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.sqlupdate.CrmColumn;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description:  工作流抄送过滤类型
 * @Author:: weikangning
 * @Date: 2020/10/13 11:07
 */
public enum ActivityCopyFilterTypeEnum {

  POS("0","职位"),
  UNDER_ROLE_ALL_POS("1","角色下所有组织"),
  CURRENT_POS_AND_ALL_PARENT("2","提交人组织及其上级所有组织"),
  CURRENT_POS("3","提交人当前组织"),

  ;

  private String code;
  private String des;

  ActivityCopyFilterTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }
  public String getDes() {
    return des;
  }


  public static String getStatusName(String code){
    ActApproveStatusEnum[] values = ActApproveStatusEnum.values();
    String desc=null;
    for (ActApproveStatusEnum o : values){
      if(StringUtils.equals(o.getCode(),code)){
        desc=o.getDes();
        break;
      }
    }
    return desc;
  }
}
