package com.biz.crm.eunm.dms;

import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import lombok.Data;
import lombok.SneakyThrows;

/**
 * 促销控件类型枚举
 * @Author: chenrong
 * @Date: 2021/4/23 18:03
 */
@Data
public class ControlTypeDynamicEnum {

  //促销阶梯控件类型字典编码
  private static final String CONTROL_TYPE_DICT_CODE = "dms_promotion_control_type";

  public static final ControlTypeDynamicEnum AMOUNT_AMOUNT = new ControlTypeDynamicEnum("amountAmount", "金额-金额");
  public static final ControlTypeDynamicEnum AMOUNT_COUNT = new ControlTypeDynamicEnum("amountCount", "金额-数量");
  public static final ControlTypeDynamicEnum AMOUNT_PRICE = new ControlTypeDynamicEnum("amountPrice", "金额-价格");
  public static final ControlTypeDynamicEnum AMOUNT_RATIO = new ControlTypeDynamicEnum("amountRatio", "金额-比例");
  public static final ControlTypeDynamicEnum COUNT_AMOUNT = new ControlTypeDynamicEnum("countAmount", "数量-金额");
  public static final ControlTypeDynamicEnum COUNT_COUNT = new ControlTypeDynamicEnum("countCount", "数量-数量");
  public static final ControlTypeDynamicEnum COUNT_PRICE = new ControlTypeDynamicEnum("countPrice", "数量-价格");
  public static final ControlTypeDynamicEnum COUNT_RATIO = new ControlTypeDynamicEnum("countRatio", "数量-比例");
  public static final ControlTypeDynamicEnum NONE_PRICE = new ControlTypeDynamicEnum("nonePrice", "空值-价格");
  public static final ControlTypeDynamicEnum NONE_RATIO = new ControlTypeDynamicEnum("noneRatio", "空值-比例");
  public static final ControlTypeDynamicEnum LIMITED_COUNT = new ControlTypeDynamicEnum("limitedCount", "空值-比例");

  private String code;

  private String desc;

  /**
   * 获取所有枚举值
   * @return
   */
  public static List<ControlTypeDynamicEnum> getEnums() {
    List<DictDataVo> controlTypes = DictUtil.tree(CONTROL_TYPE_DICT_CODE);
    if(CollectionUtil.listEmpty(controlTypes)) {
      return getAllStaticEnums();
    }
    List<ControlTypeDynamicEnum> enums = Lists.newArrayList();
    controlTypes.forEach(type -> {
      enums.add(new ControlTypeDynamicEnum(type.getDictCode(), type.getDictValue()));
    });
    return enums;
  }

  /**
   * 获取所有静态枚举
   * @return
   */
  @SneakyThrows
  public static List<ControlTypeDynamicEnum> getAllStaticEnums(){
    Class cls = ControlTypeDynamicEnum.class;
    Field[] declaredFields = cls.getDeclaredFields();
    List<ControlTypeDynamicEnum> enums = Lists.newArrayList();
    for(Field f : declaredFields) {
      String modifier = Modifier.toString(f.getModifiers());
      if(Objects.equals(modifier, "public static final")) {
        f.setAccessible(true);
        enums.add((ControlTypeDynamicEnum) f.get(null));
      }
    }
    return enums;
  }

  ControlTypeDynamicEnum(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  /**
   * 根据编码获取枚举
   * @param type
   * @return
   */
  public static ControlTypeDynamicEnum getByCode(String type) {
    List<ControlTypeDynamicEnum> enums = getAllStaticEnums();
    for(ControlTypeDynamicEnum en : enums) {
      if(Objects.equals(en.getCode(), type)) {
        return en;
      }
    }
    return null;
  }
}
