package com.biz.crm.eunm.job;

/**
 * @author jerry7
 * @date 2020/12/22 10:43
 */
public enum JobIndicatorStr {

    //java默认传递glueSource
    GLUE_SOURCE_JAVA("GLUE_GROOVY", "package com.xxl.job.service.handler;\n" +
            "\n" +
            "import com.biz.crm.core.xxllog.XxlJobLogger;\n" +
            "import com.biz.crm.core.biz.model.ReturnT;\n" +
            "import com.biz.crm.core.handler.IJobHandler;\n" +
            "\n" +
            "public class DemoGlueJobHandler extends IJobHandler {\n" +
            "\n" +
            "\t@Override\n" +
            "\tpublic ReturnT<String> execute(String param) throws Exception {\n" +
            "\t\tXxlJobLogger.log(\"XXL-JOB, Hello World.\");\n" +
            "\t\treturn ReturnT.SUCCESS;\n" +
            "\t}\n" +
            "\n" +
            "}\n"),
    //bean 默认传递glueSource
    GLUE_SOURCE_BEAN("BEAN", ""),
    //shell 默认传递glueSource
    GLUE_SOURCE_SHELL("GLUE_SHELL)", "#!/bin/bash\n" +
            "echo \"xxl-job: hello shell\"\n" +
            "\n" +
            "echo \"脚本位置：$0\"\n" +
            "echo \"任务参数：$1\"\n" +
            "echo \"分片序号 = $2\"\n" +
            "echo \"分片总数 = $3\"\n" +
            "<#--echo \"参数数量：$#\"\n" +
            "for param in $*\n" +
            "do\n" +
            "    echo \"参数 : $param\"\n" +
            "    sleep 1s\n" +
            "done-->\n" +
            "\n" +
            "echo \"Good bye!\"\n" +
            "exit 0"),
    //python默认保存glueSource
    GLUE_SOURCE_PYTHON("GLUE_PYTHON)", "#!/usr/bin/python\n" +
            "# -*- coding: UTF-8 -*-\n" +
            "import time\n" +
            "import sys\n" +
            "\n" +
            "print \"xxl-job: hello python\"\n" +
            "\n" +
            "print \"脚本位置：\", sys.argv[0]\n" +
            "print \"任务参数：\", sys.argv[1]\n" +
            "print \"分片序号：\", sys.argv[2]\n" +
            "print \"分片总数：\", sys.argv[3]\n" +
            "<#--for i in range(1, len(sys.argv)):\n" +
            "\ttime.sleep(1)\n" +
            "\tprint \"参数\", i, sys.argv[i]-->\n" +
            "\n" +
            "print \"Good bye!\"\n" +
            "exit(0)\n" +
            "<#--\n" +
            "import logging\n" +
            "logging.basicConfig(level=logging.DEBUG)\n" +
            "logging.info(\"脚本文件：\" + sys.argv[0])\n" +
            "-->"),
    //php默认传递glueSource参数
    GLUE_SOURCE_PHP("GLUE_PHP","<?php\n" +
            "\n" +
            "    echo \"xxl-job: hello php  \\n\";\n" +
            "\n" +
            "    echo \"脚本位置：$argv[0]  \\n\";\n" +
            "    echo \"任务参数：$argv[1]  \\n\";\n" +
            "    echo \"分片序号 = $argv[2]  \\n\";\n" +
            "    echo \"分片总数 = $argv[3]  \\n\";\n" +
            "\n" +
            "    echo \"Good bye!  \\n\";\n" +
            "    exit(0);\n" +
            "\n" +
            "?>"),
    //nodejs默认传递glueSource参数
    GLUE_SOURCE_NODEJS("GLUE_NODEJS","#!/usr/bin/env node\n" +
            "console.log(\"xxl-job: hello nodejs\")\n" +
            "\n" +
            "var arguments = process.argv\n" +
            "\n" +
            "console.log(\"脚本位置: \" + arguments[1])\n" +
            "console.log(\"任务参数: \" + arguments[2])\n" +
            "console.log(\"分片序号: \" + arguments[3])\n" +
            "console.log(\"分片总数: \" + arguments[4])\n" +
            "<#--for (var i = 2; i < arguments.length; i++){\n" +
            "\tconsole.log(\"参数 %s = %s\", (i-1), arguments[i]);\n" +
            "}-->\n" +
            "\n" +
            "console.log(\"Good bye!\")\n" +
            "process.exit(0)"),
    //powerShell默认传递glueSource
    GLUE_SOURCE_POWER_SHELL("GLUE_POWERSHELL","Write-Host \"xxl-job: hello powerShell\"\n" +
            "\n" +
            "Write-Host \"$脚本位置: \" $MyInvocation.MyCommand.Definition\n" +
            "Write-Host \"执行参数: \"\n" +
            "\tif ($args.Count -gt 2) { $args[0..($args.Count-3)] }\n" +
            "Write-Host \"分片序号: \" $args[$args.Count-2]\n" +
            "Write-Host \"分片总数: \" $args[$args.Count-1]\n" +
            "\n" +
            "Write-Host \"Good bye!\"\n" +
            "exit 0");


    private String code;

    private String label;

    JobIndicatorStr(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public String getCode() {
        return code;
    }

    public String getLabel() {
        return label;
    }

}