package com.biz.crm.eunm.kms;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Project crm
 * @PackageName com.biz.crm.eunm.kms
 * @ClassName KmsEnum
 * @Author Gavin
 * @Date 2021/4/28 下午3:31
 * @Description 抓单枚举
 */
public class KmsEnum {
    /**
     * 抓单方式
     */
    @Getter
    public enum OrderStatus {
        S100("100", "转换失败"),
        S101("101", "待转换"),
        S200("200", "待确认"),
        S300("300", "已确认"),
        S400("400", "待处理"),
        S500("500", "传送SAP成功"),
        S501("501", "传送SAP失败"),
        S600("600", "已匹配"),
        ;

        private String value;
        private String description;

        OrderStatus(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsEnum.OrderStatus type : KmsEnum.OrderStatus.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 抓单状态
     */
    @Getter
    public enum GrabState {
        SUCCEED("0", "成功"),
        FAILED("1", "失败"),
        GRAB_ING("2", "抓取中");

        private String value;
        private String description;

        GrabState(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsEnum.GrabState type : KmsEnum.GrabState.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 稽核浮动规则
     */
    @Getter
    public enum AuditRule {
        Z("Z", "正"),
        F("F", "负"),
        UD("UD", "上下浮动"),
        ;

        private String value;
        private String description;

        AuditRule(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsEnum.AuditRule type : KmsEnum.AuditRule.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 稽核状态（待确认/已确认）
     */
    @Getter
    public enum AuditStatus {
        WAIT("WAIT", "待确认"),
        CONFIRMED("CONFIRMED", "已确认"),
        ;

        private String value;
        private String description;

        AuditStatus(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsEnum.AuditStatus type : KmsEnum.AuditStatus.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 稽核匹配结果（待匹配/无差异/有差异）
     */
    @Getter
    public enum AuditResult {
        WAIT("WAIT", "待匹配"),
        NO_DIFFERENCE("NO_DIFFERENCE", "无差异"),
        DIFFERENCE("DIFFERENCE", "有差异"),
        PRICE_DIFF("PRICE_DIFF", "价差"),
        QUANTITY_DIFF("QUANTITY_DIFF", "量差"),
        PRICE_QUANTITY_DIFF("PRICE_QUANTITY_DIFF", "价量差"),
        ;

        private String value;
        private String description;

        AuditResult(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsEnum.AuditResult type : KmsEnum.AuditResult.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 稽核条件逻辑
     */
    @Getter
    public enum AuditCondition {
        PDS("PDS", "商品-日期-门店"),
        DS("DS", "日期-门店"),
        ;

        private String value;
        private String description;

        AuditCondition(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsEnum.AuditCondition type : KmsEnum.AuditCondition.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 稽核单据
     */
    @Getter
    public enum AuditOrderType {
        ACCEPTANCE("ACCEPTANCE", "验收单"),
        ORDER_ACCEPTANCE("ORDER_ACCEPTANCE", "订货单+验收单"),
        ;

        private String value;
        private String description;

        AuditOrderType(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsEnum.AuditOrderType type : KmsEnum.AuditOrderType.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }
}