package com.biz.crm.eunm.kms;


import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author maoshen
 * @date 2021/6/26.
 */
public enum KmsProductTypeEnum {
    roomTemperature("room_temp", "常温"),
    lowTemperature("low_temp", "低温");

    private String code;
    private String des;

    KmsProductTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }


    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * des 和  code 的map
     */
    public static Map<String, String> valueKeyMap() {
        Map<String, String> map = Maps.newHashMap();
        map.put(roomTemperature.des, roomTemperature.code);
        map.put(lowTemperature.des, lowTemperature.code);
        return map;
    }
}
