package com.biz.crm.eunm.mdm;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.Getter;

import java.util.Map;
import java.util.Set;

/**
 * @author maoshen
 * @date 2021/6/2.
 */

@Getter
public enum FilterEnum {
    ORG("1", "(orgId=*)"),
    INCREMENT_ORG("2", "(&(orgId=*)(|(createtime>=incrementTime)(modifytime>=incrementTime)))"),
    USER("3", "(userId=*)"),
    INCREMENT_USER("4", "(&(userId=*)(|(usercreatetime>=incrementTime)(modifytimestamp>=incrementTime)))"),
    ;

    private String code;
    private String desc;

    FilterEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Map<String, String> getFilters() {
        Map<String, String> map = Maps.newHashMap();
        map.put(ORG.code, ORG.desc);
        map.put(INCREMENT_USER.code, INCREMENT_USER.desc);
        map.put(INCREMENT_ORG.code, INCREMENT_ORG.desc);
        map.put(USER.code, USER.desc);
        return map;
    }

    public static Set<String> needOrgUrlSet() {
        Set<String> set = Sets.newHashSet();
        set.add(ORG.code);
        set.add(INCREMENT_ORG.code);
        return set;
    }
}
