package com.biz.crm.eunm.mdm;

import java.util.HashMap;
import java.util.Map;

/**
 * 经销商或客户细类
 * @author yangshan
 * @date 2021/4/13 0:17
 */
public class MdmCustomerOrTerminalEnum {

    /**
     * 客户类型
     */
    public enum customerType{

        PROVINCE_LEVEL("province_level","省级"),
        CITY_LEVEL("city_level","市级"),
        DISTRICT_LEVEL("district_level","区级"),
        REGIONAL_LEVEL("regional_level","地区级"),
        CUSTOMER_TYPE_01("customer_type_01","经销商客户"),
        ;
        private String val;
        private String desc;

        customerType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (MdmCodeEnum.NoticeCode type : MdmCodeEnum.NoticeCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 终端类型
     */
    public enum terminalType{

        ONE("1","经销商门店"),
        TWO("2","直营门店"),
        ;
        private String val;
        private String desc;

        terminalType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (MdmCodeEnum.NoticeCode type : MdmCodeEnum.NoticeCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}
