package com.biz.crm.eunm.mdm;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 组织类型枚举
 * @Author Gavin
 * @Date Created in 2021/5/20 下午3:57
 */
@Getter
public enum MdmOrgTypeEnum {
    GROUP("group", "集团"),
    COMPANY("company", "公司"),
    DIVISION("division", "事业部"),
    REGION("region", "大区"),
    AREA("area", "营业区"),
    DEPARTMENT("department", "部门"),
    ;

    private String value;
    private String description;

    MdmOrgTypeEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Map<String, String> GETMAP = new HashMap<>();

    static {
        for (MdmOrgTypeEnum type : MdmOrgTypeEnum.values()) {
            GETMAP.put(type.getValue(), type.getDescription());
        }
    }
}
