package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;


/**
 * SFA 附件
 *  @author: luoqi
 *  @Date: 2021-4-7 15:57
 *  @version: V1.0
 *  @Description:
 */
public enum AttachmentBizTypeEnum {
    TASK_ADD("task_add", "任务新增"),
    TASK_EXECUTE("task_execute", "任务执行"),
    ACTIVITY_REQUIRE0("activity_require0", "活动执行要求-活动照"),
    ACTIVITY_REQUIRE1("activity_require1", "活动执行要求-门头照"),
    ACTIVITY_REQUIRE2("activity_require2", "活动执行要求-陈列照"),
    VISIT_STEP_IN_STORE("visit_step_in_store", "进店"),
    VISIT_STEP_OUT_STORE("visit_step_out_store", "离店"),
    VISIT_PLAN_EX("visit_plan_ex", "拜访异常提报"),
    VISIT_STEP_COLLET("visit_step_collet", "竞品采集"),
    VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY("visit_step_store_check_regular_shelf_display", "常规货架陈列"),
    VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY("visit_step_store_check_material_display", "物料陈列"),
    VISIT_STEP_STORE_CHECK_PRICE("visit_step_store_check_price", "价格签");


    ;
    private String val;
    private String desc;

    AttachmentBizTypeEnum(String val, String desc) {
        this.val = val;
        this.desc = desc;
    }
    public static final String ACTIVITY_REQUIRE = "activity_require";
    public static final Map<String, String> GETMAP = new HashMap<>();
    public static final Map<String, AttachmentBizTypeEnum> VAL_MAP_ENUM = new HashMap<>();
    static {
        for (AttachmentBizTypeEnum type : AttachmentBizTypeEnum.values()) {
            GETMAP.put(type.getVal(), type.getDesc());
            VAL_MAP_ENUM.put(type.getVal(), type);
        }
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
