package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description:  活动明细产品类型枚举
 * @Author:: weikangning
 * @Date: 2020/10/13 11:07
 */
public enum ActDetailProductTypeEnum {
  NORMAL("normal","本品"),
  GIFT("gift","赠品"),
  REPLENISHMENT("replenishment","货补产品"),
  EXECUTION("execution","执行产品"),
  ;

  private String code;
  private String des;

  ActDetailProductTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }
  public String getDes() {
    return des;
  }


  public static String getStatusName(String code){
    ActApproveStatusEnum[] values = ActApproveStatusEnum.values();
    String desc=null;
    for (ActApproveStatusEnum o : values){
      if(StringUtils.equals(o.getCode(),code)){
        desc=o.getDes();
        break;
      }
    }
    return desc;
  }
}
