package com.biz.crm.util;

import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.util
 * @ClassName ActivitiUtils
 * @Author HuangLong
 * @Date 2021/5/7 9:47
 * @Description 工作流工具类
 */
@Slf4j
@Component
public class ActivityUtils {

    private static TaActBaseFeign actBaseFeign;


    @Autowired
    public void setActBaseFeign(TaActBaseFeign actBaseFeign){
        ActivityUtils.actBaseFeign=actBaseFeign;
    }


    public static String startProcess(StartProcessReqVo processReqVo){
        ActivitiBusinessVo activitiBusinessVo= new ActivitiBusinessVo();
        activitiBusinessVo.setProcessKey(processReqVo.getProcessKey());
        activitiBusinessVo.setBusinessId(processReqVo.getFormNo());
        activitiBusinessVo.setBusinessNo(processReqVo.getBusinessCode());
        activitiBusinessVo.setRemark(processReqVo.getRemark());
        activitiBusinessVo.setVariables(processReqVo.getVariables());
        activitiBusinessVo.setCostType(processReqVo.getCostType());
        activitiBusinessVo.setFormType(processReqVo.getFormType());
        activitiBusinessVo.setProcessTitle(processReqVo.getTitle());
        activitiBusinessVo.setKeyTargetListJson(processReqVo.getKeyTargetListJson());
        activitiBusinessVo.setCallBackFeign(processReqVo.getCallBackFeign());
        activitiBusinessVo.setPositionCode(processReqVo.getPosCode());
        if(CollectionUtils.isNotEmpty(processReqVo.getFileList())){
            List<AttachmentVo> attachmentVos = processReqVo.getFileList().stream().map(o -> {
                AttachmentVo attachmentVo = new AttachmentVo();
                attachmentVo.setFileName(o.getObjectName());
                attachmentVo.setObjectName(o.getObjectName());
                attachmentVo.setFileAddress(o.getFileAddress());
                return attachmentVo;
            }).collect(Collectors.toList());
            activitiBusinessVo.setAttachmentVos(attachmentVos);
        }
        activitiBusinessVo.setCommitName(processReqVo.getCommitName());
        activitiBusinessVo.setCommitCode(processReqVo.getCommitCode());
        activitiBusinessVo.setCommitByOrg(processReqVo.getCommitByOrg());
        activitiBusinessVo.setCommitByOrgName(processReqVo.getCommitByOrgName());
        activitiBusinessVo.setCommitPos(processReqVo.getCommitPos());
        activitiBusinessVo.setCommitPosName(processReqVo.getCommitPosName());
        Result<String> stringResult = actBaseFeign.startProcess(activitiBusinessVo);
        String s = ApiResultUtil.objResult(stringResult, true);
        return s;
    }


    public static String startProcess(ActivitiBusinessVo activitiBusinessVo){
        Result<String> stringResult = actBaseFeign.startProcess(activitiBusinessVo);
        if(stringResult == null){
            throw new BusinessException("进入熔断");
        }
        if(!stringResult.isSuccess()){
            throw new BusinessException(stringResult.getMessage());
        }
        String s = stringResult.getResult();
        if(StringUtils.isEmpty(s)){
            throw new BusinessException("流程提交失败");
        }
        return s;
    }

    /**
     * 执行工作流回调
     * @param callBackVo
     */
    public static void processCallBack(ActivitiCallBackVo callBackVo){
        //为防止回调时忘记设置必要参数,进行参数校验
        AssertUtils.isNotEmpty(callBackVo.getCallBackFeign(),"回调方法不能为空");
        AssertUtils.isNotNull(callBackVo.getProcessState(),"流程状态不能为空");
        AssertUtils.isNotEmpty(callBackVo.getFormNo(),"业务编码不能为空");
        AssertUtils.isNotEmpty(callBackVo.getProcessNo(),"流程实例编码不能为空");
        CallbackFeign callbackFeign=null;
        callbackFeign =(CallbackFeign)SpringApplicationContextUtil.getApplicationContext().getBean(callBackVo.getCallBackFeign());
            Result callback = callbackFeign.callback(callBackVo);
            if(!callback.isSuccess()) {
                throw new BusinessException("修改业务系统单据状态失败,失败原因:" + callback.getMessage());
            }
    }
}
