package com.biz.crm.util;

import com.alibaba.fastjson.JSONArray;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 集合工具类
 */
public class CollectionUtil {

    /**
     * @param collection 集合类型
     * @return
     * @Description: (判断collection集合不为空)
     */
    public static boolean collectionNotEmpty(@SuppressWarnings("rawtypes") Collection collection) {
        return CollectionUtils.isNotEmpty(collection);
    }

    /**
     * @param list 集合类型
     * @return
     * @Description: (判断list集合为空)
     */
    public static boolean listEmpty(@SuppressWarnings("rawtypes") List list) {
        return CollectionUtils.isEmpty(list);
    }

    /**
     * @param list 集合类型
     * @return
     * @Description: (判断list集合不为空)
     */
    public static boolean listNotEmpty(@SuppressWarnings("rawtypes") List list) {
        return CollectionUtils.isNotEmpty(list);
    }

    /**
     * @param list 集合类型
     * @return
     * @Description: (判断list集合不为空并且大小大于0)
     */
    public static boolean listNotEmptyNotSizeZero(@SuppressWarnings("rawtypes") List list) {
        return listNotEmpty(list) && list.size() > 0;
    }

    /**
     * @param map 集合类型
     * @return
     * @Description: (判断map集合不为空)
     */
    public static boolean mapNotEmpty(@SuppressWarnings("rawtypes") Map map) {
        return MapUtils.isNotEmpty(map);
    }
    /**
     * 判断{@link JSONArray}是否为空
     *
     * @param data
     * @return
     */
    public static boolean jsonArrayEmpty(JSONArray data) {
        return data == null || data.size() == 0;
    }

    /**
     * 判断map是否为空
     *
     * @param map
     * @return
     */
    public static boolean mapEmpty(Map map) {
        return MapUtils.isEmpty(map);
    }


    /**
     * List集合按指定数量分组
     *
     * @param list
     * @param quantity
     * @return
     */
    public static List<List<String>> groupListByQuantity(List<String> list, int quantity) {
        List<List<String>> tempList = new ArrayList<>();
        if (list == null || list.size() == 0) {
            return tempList;
        }
        int count = 0;
        while (count < list.size()) {
            tempList.add(list.subList(count, Math.min((count + quantity), list.size())));
            count += quantity;
        }
        return tempList;
    }
}
