package com.biz.crm.util;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.mdm.tableconfig.MdmColumnConfigPersonalFeign;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.service.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.*;

/**
 * 字段配置个性设置工具类
 */
@Slf4j
@Component
public class ColumnConfigPersonalUtil {

    private static RedisService redisService;

    private static MdmColumnConfigPersonalFeign mdmColumnConfigPersonalFeign;

    @Autowired
    public void setRedisService(RedisService redis) {
        ColumnConfigPersonalUtil.redisService = redis;
    }

    @Autowired
    public void setMdmColumnConfigPersonalFeign(MdmColumnConfigPersonalFeign columnConfigPersonalFeign) {
        ColumnConfigPersonalUtil.mdmColumnConfigPersonalFeign = columnConfigPersonalFeign;
    }

    /**
     * 获取列表字段个性设置
     *
     * @param parentCode   菜单编码
     * @param functionCode 列表功能编码
     * @param positionCode 职位编码
     * @return
     */
    public static List<MdmColumnConfigPersonalRespVo> getColumnConfigPersonal(String parentCode, String functionCode, String positionCode) {
        Assert.hasText(parentCode, "缺失菜单编码");
        Assert.hasText(functionCode, "缺失功能编码");
        Assert.hasText(positionCode, "缺失职位编码");
        List<MdmColumnConfigPersonalRedisVo> redisList = get(parentCode, functionCode, positionCode);
        if (redisList != null && redisList.size() > 0) {
            return CrmBeanUtil.copyList(redisList, MdmColumnConfigPersonalRespVo.class);
        }
        return new ArrayList<>();
    }

    /**
     * 清除缓存
     *
     * @param parentCode   菜单编码
     * @param functionCode 列表功能编码
     */
    public static void deleteColumnConfig(String parentCode, String functionCode) {
        Assert.hasText(parentCode, "缺失菜单编码");
        Assert.hasText(functionCode, "缺失功能编码");
        redisService.del(connectHashKey(RedisParam.MDM_COLUMN_CONFIG_PERSONAL, parentCode, functionCode));
        redisService.del(connectHashKey(RedisParam.MDM_COLUMN_CONFIG_PERSONAL_LOCK, parentCode, functionCode));
    }

    /**
     * 清除缓存
     *
     * @param parentCode   菜单编码
     * @param functionCode 列表功能编码
     * @param positionCode 职位编码
     */
    public static void deleteColumnConfigPersonal(String parentCode, String functionCode, String positionCode) {
        Assert.hasText(parentCode, "缺失菜单编码");
        Assert.hasText(functionCode, "缺失功能编码");
        Assert.hasText(positionCode, "缺失职位编码");
        redisService.hdel(connectHashKey(RedisParam.MDM_COLUMN_CONFIG_PERSONAL, parentCode, functionCode), positionCode);
        redisService.hdel(connectHashKey(RedisParam.MDM_COLUMN_CONFIG_PERSONAL_LOCK, parentCode, functionCode), positionCode);
    }

    /*-------------------------------------------------以下为私有方法-------------------------------------------------*/

    private static List<MdmColumnConfigPersonalRedisVo> get(String parentCode, String functionCode, String positionCode) {
        List<MdmColumnConfigPersonalRedisVo> list = new ArrayList<>();
        String lockHashKey = connectHashKey(RedisParam.MDM_COLUMN_CONFIG_PERSONAL_LOCK, parentCode, functionCode);
        String hashKey = connectHashKey(RedisParam.MDM_COLUMN_CONFIG_PERSONAL, parentCode, functionCode);
        Object o = redisService.hget(lockHashKey, positionCode);
        if (o == null) {
            Object obj = redisService.hget(hashKey, positionCode);
            if (obj == null) {
                Result<List<MdmColumnConfigPersonalRedisVo>> result = mdmColumnConfigPersonalFeign.findColumnConfigPersonalRedisList(parentCode, functionCode, positionCode);
                Assert.isTrue(result.isSuccess(), "查询个性设置失败：" + result.getMessage());
                List<MdmColumnConfigPersonalRedisVo> redisList = result.getResult();
                if (redisList == null || redisList.size() == 0) {
                    redisService.hset(lockHashKey, positionCode, positionCode, RedisParam.SECONDS_OF_MONTH);
                } else {
                    redisService.hset(hashKey, positionCode, redisList, RedisParam.SECONDS_OF_MONTH);
                    list.addAll(redisList);
                }
            } else {
                list.addAll((List<MdmColumnConfigPersonalRedisVo>) obj);
            }
        }
        return list;
    }

    private static String connectHashKey(String prefix, String parentCode, String functionCode) {
        return prefix + parentCode + ":" + functionCode;
    }


}
