package com.biz.crm.util;

import com.alibaba.excel.util.CollectionUtils;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.mdm.permission.MdmDataPermissionFeign;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSetVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-03-01 15:29
 **/
public class PermissionUtil {

    private static final Logger log = LoggerFactory.getLogger(PermissionUtil.class);

    private static MdmDataPermissionFeign mdmDataPermissionFeign;

    public static List<MdmPermissionSetVo> currentUserPermissionSql(){
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = SpringApplicationContextUtil.getApplicationContext().getBean(MdmDataPermissionFeign.class);
        }
        return Optional.ofNullable(mdmDataPermissionFeign.currentUserPermissionSql())
                .map(Result::getResult)
                .orElse(new ArrayList<>());
    }

    public static MdmCurrentPermissionRespVo currentUserPermissionList(){
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = SpringApplicationContextUtil.getApplicationContext().getBean(MdmDataPermissionFeign.class);
        }
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        Object functionCodeObj = ThreadLocalUtil.getObj(GlobalParam.FUNCTION_CODE);
        String menuCode= Objects.nonNull(menuCodeObj) ? menuCodeObj.toString() : null ;
        String functionCode= Objects.nonNull(functionCodeObj) ? functionCodeObj.toString() : null ;
        log.info("[权限工具类]菜单编码:{}",menuCode);
        log.info("[权限工具类]功能编码:{}",functionCode);
        if (StringUtils.isEmpty(menuCode) || StringUtils.isEmpty(functionCode)) {
            return new MdmCurrentPermissionRespVo();
        }
        return Optional.ofNullable(mdmDataPermissionFeign.currentUserDataPermission(menuCode, functionCode))
                .map(Result::getResult)
                .map(x->{
                    List<String> permissionObjCodeList = Optional.ofNullable(x.getPermissionObjCodeList()).orElse(new ArrayList<>());
                    List<String> excludePermissionObjCodeList = Optional.ofNullable(x.getExcludePermissionObjCodeList()).orElse(new ArrayList<>());
                    List<String> filterPermissionObjCodeList = permissionObjCodeList.stream()
                            .filter(k -> CollectionUtils.isEmpty(excludePermissionObjCodeList) || !excludePermissionObjCodeList.contains(k))
                            .collect(Collectors.toList());
                    x.setFilterPermissionObjCodeList(filterPermissionObjCodeList);
                    x.setPermissionObjCodeList(permissionObjCodeList);
                    x.setExcludePermissionObjCodeList(excludePermissionObjCodeList);
                    return x;
                })
                .orElse(new MdmCurrentPermissionRespVo());
    }
}
