package com.biz.crm.util.cache.mdm;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.mdm.function.MdmFunctionFeign;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.service.RedisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 菜单缓存
 *
 * @author zxw
 * @date 2021-04-01 18:15
 **/
@Component
public class FunctionUtil {

    private static RedisService redisService;

    private static MdmFunctionFeign mdmFunctionFeign;

    @Autowired
    public void setRedisService(RedisService redisService) {
        FunctionUtil.redisService = redisService;
    }

    @Autowired
    public void setMdmFunctionFeign(MdmFunctionFeign mdmFunctionFeign) {
        FunctionUtil.mdmFunctionFeign = mdmFunctionFeign;
    }

    public static List<MdmFunctionRespVo> findAllFunction() {
        List<MdmFunctionRespVo> result = new ArrayList<>();
        List<Object> list = (List<Object>) redisService.get(RedisParam.MDM_FUNCTION);
        if (!CollectionUtils.isEmpty(list)) {
            for (Object o : list) {
                result.add(((MdmFunctionRespVo) o));
            }
            return result;
        }
        List<MdmFunctionRespVo> dbList = mdmFunctionFeign.list(new MdmFunctionReqVo()).getResult();
        if (CollectionUtils.isEmpty(dbList)) {
            return new ArrayList<>();
        }
        redisService.setDays(RedisParam.MDM_FUNCTION, dbList, RedisParam.TIME1);
        return dbList;
    }

    public static void clear() {
        redisService.del(RedisParam.MDM_FUNCTION);
    }
}
