package com.biz.crm.util.es.permission;

import com.biz.crm.base.config.ThreadLocalUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;


/**
 * ES数据权限注解配置切面
 *  @author: luoqi
 *  @Date: 2021-5-7 11:26
 *  @version: V1.0
 *  @Description:
 */
@Aspect
@Component
@Slf4j
public class EsDataPermissionAspect {
    public static final String ES_DATA_PERMISSION_KEY = "ES_DATA_PERMISSION_KEY";

    @Before("@annotation(EsDataPermission)")
    public void doBefore(JoinPoint joinPoint) throws NoSuchMethodException {
        Class clazz = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Class[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterTypes();
        Method method = clazz.getMethod(methodName, parameterTypes);
        EsDataPermission permission = method.getAnnotation(EsDataPermission.class);
        ConcurrentHashMap<String,Object> map = ThreadLocalUtil.get();
        if(null == map){
            map = new ConcurrentHashMap<>();
        }
        map.put(ES_DATA_PERMISSION_KEY, new EsDataPermissionResolver(permission));
        ThreadLocalUtil.stObj(map);
    }

    @AfterReturning(returning = "ret", pointcut = "@annotation(EsDataPermission)")
    public void doAfterReturning(Object ret)  {
        ThreadLocalUtil.delObj();
    }

    @AfterThrowing(value = "@annotation(EsDataPermission)", throwing = "throwable")
    public void doAfterThrowing(Throwable throwable) {
        ThreadLocalUtil.delObj();
    }
}
