package com.biz.crm.util.fee;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 费用池回滚工具类
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Component
public class FeePoolRollbackUtil {

    public static final String FEE_POOL_TEMP_REDIS_KEY = "FEE_POOL_TEMP_REDIS_KEY:";

    public static final String FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY = "FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY";

    private static RedisService redisService;

    @Autowired
    public void setRedisService(RedisService redis) {
        FeePoolRollbackUtil.redisService = redis;
    }


    public static void addRollbackOperationCode(String operationCode) {
        Object o = ThreadLocalUtil.get(FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY);
        List<String> list = o == null ? new ArrayList<>() : (List<String>) o;
        list.add(operationCode);
        ThreadLocalUtil.set(FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY, list);
    }

    public static String generateRollbackCode() {
        Object o = ThreadLocalUtil.get(FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY);
        List<String> list = o == null ? new ArrayList<>() : (List<String>) o;
        String rollbackCode = CodeUtil.getCodeDefault();
        redisService.setSeconds(FEE_POOL_TEMP_REDIS_KEY + rollbackCode, list, 60);
        return rollbackCode;
    }

    public static List<String> getOperationCodeListByRollbackCode(String rollbackCode) {
        Object o = redisService.get(FEE_POOL_TEMP_REDIS_KEY + rollbackCode);
        if (o != null) {
            return (List<String>) o;
        }
        return new ArrayList<>();
    }

    public static void removeRollbackCode(String rollbackCode) {
        redisService.del(FEE_POOL_TEMP_REDIS_KEY + rollbackCode);
    }

}
