package com.biz.crm.util.websocket.feign.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.util.Result;
import com.biz.crm.util.websocket.feign.WebsocketFeign;
import com.biz.crm.util.websocket.vo.WebsocketMsg;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.util.websocket.feign.impl
 * @Description: TODO
 * @date 2021/3/31 下午3:42
 */
@Slf4j
@Component
public class WebsocketFeignImpl  implements FallbackFactory<WebsocketFeign> {
    @Override
    public WebsocketFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new WebsocketFeign() {
            @Override
            public Result sendMsg(WebsocketMsg websocketMsg) {
                throw new BusinessException("进入熔断");
            }
        };
    }
}
