/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.AssertUtils;
import java.math.BigDecimal;

public class NumberUtil {
    private static final String[] CN_NUM = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CN_UNIT = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343"};
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final String CN_POINT = "\u70b9";

    private NumberUtil() {
    }

    public static String int2chineseNum(int intNum) {
        StringBuffer sb = new StringBuffer();
        boolean isNegative = false;
        if (intNum < 0) {
            isNegative = true;
            intNum *= -1;
        }
        int count = 0;
        while (intNum > 0) {
            sb.insert(0, CN_NUM[intNum % 10] + CN_UNIT[count]);
            intNum /= 10;
            ++count;
        }
        if (isNegative) {
            sb.insert(0, CN_NEGATIVE);
        }
        return sb.toString().replaceAll("\u96f6[\u5343\u767e\u5341]", "\u96f6").replaceAll("\u96f6+\u4e07", "\u4e07").replaceAll("\u96f6+\u4ebf", "\u4ebf").replaceAll("\u4ebf\u4e07", "\u4ebf\u96f6").replaceAll("\u96f6+", "\u96f6").replaceAll("\u96f6$", "");
    }

    public static String bigDecimal2chineseNum(BigDecimal bigDecimalNum) {
        int signum;
        if (bigDecimalNum == null) {
            return CN_NUM[0];
        }
        StringBuffer sb = new StringBuffer();
        String numStr = bigDecimalNum.abs().stripTrailingZeros().toPlainString();
        String[] split = numStr.split("\\.");
        String integerStr = NumberUtil.int2chineseNum(Integer.parseInt(split[0]));
        sb.append(integerStr);
        if (split.length == 2) {
            sb.append(CN_POINT);
            String decimalStr = split[1];
            char[] chars = decimalStr.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                int index = Integer.parseInt(String.valueOf(chars[i]));
                sb.append(CN_NUM[index]);
            }
        }
        if ((signum = bigDecimalNum.signum()) == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        return sb.toString();
    }

    public static void checkNumber(BigDecimal amount, String propertyName, BigDecimal bottom, BigDecimal top) {
        AssertUtils.isNotNull(amount, propertyName + "\u4e0d\u80fd\u4e3a\u7a7a");
        if (bottom != null) {
            AssertUtils.isTrue(amount.compareTo(bottom) >= 0, propertyName + "\u4e0d\u80fd\u5c0f\u4e8e" + bottom);
        }
        if (top != null) {
            AssertUtils.isTrue(amount.compareTo(top) <= 0, propertyName + "\u4e0d\u80fd\u5927\u4e8e" + bottom);
        }
    }
}

