/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.org.MdmOrgRedisFeign;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrgUtil {
    private static final Logger log = LoggerFactory.getLogger(OrgUtil.class);
    private static RedisService redisService;
    private static MdmOrgRedisFeign mdmOrgRedisFeign;
    private static MdmOrgFeign mdmOrgFeign;
    public static Map<String, MdmOrgRespVo> orgMap;
    public static Map<String, List<MdmOrgRespVo>> orgTreeMap;
    public static String orgloaclCach;
    public static String orgloaclCachversion;

    public static void setVersion() {
        String version = UUID.randomUUID().toString().replaceAll("-", "");
        redisService.setDays(orgloaclCach, (Object)version, 3L);
    }

    public static String getVersion() {
        String version = null;
        Object o = redisService.get(orgloaclCach);
        if (o == null) {
            version = UUID.randomUUID().toString().replaceAll("-", "");
            redisService.setDays(orgloaclCach, (Object)version, 3L);
        } else {
            version = o.toString();
        }
        return version;
    }

    public static boolean checkVersion() {
        String version = OrgUtil.getVersion();
        return orgloaclCachversion.equals(version);
    }

    public static void initOrg() {
        if (OrgUtil.checkVersion()) {
            return;
        }
        OrgUtil.initOrgsys();
    }

    private static synchronized void initOrgsys() {
        if (OrgUtil.checkVersion()) {
            return;
        }
        orgMap.clear();
        orgTreeMap.clear();
        ArrayList mdmOrgRespVos = Lists.newArrayList();
        int pageSize = 200;
        int pageNum = 0;
        while (true) {
            MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
            mdmOrgReqVo.setPageSize(Integer.valueOf(pageSize));
            mdmOrgReqVo.setPageNum(Integer.valueOf(pageNum));
            PageResult orgPage = (PageResult)ApiResultUtil.objResult((Result)mdmOrgFeign.findAllPage(mdmOrgReqVo), (boolean)true);
            if (CollectionUtils.isNotEmpty((Collection)orgPage.getData())) {
                mdmOrgRespVos.addAll(orgPage.getData());
            }
            log.info("\u5df2\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u5927\u5c0f:{}", (Object)mdmOrgRespVos.size());
            if (CollectionUtils.isEmpty((Collection)orgPage.getData()) || orgPage.getData().size() < pageSize) break;
            ++pageNum;
        }
        ArrayList<MdmOrgRespVo> tempList = new ArrayList<MdmOrgRespVo>();
        for (MdmOrgRespVo org : mdmOrgRespVos) {
            orgMap.put(org.getOrgCode(), org);
            if (StringUtils.isEmpty((CharSequence)org.getParentCode())) {
                orgTreeMap.put(org.getOrgCode(), new ArrayList());
                continue;
            }
            tempList.add(org);
        }
        HashMap orgListMap = new HashMap();
        tempList.stream().collect(Collectors.groupingBy(MdmOrgRespVo::getParentCode, Collectors.toList())).forEach((parentCode, list) -> orgListMap.put(parentCode, list));
        if (!orgTreeMap.isEmpty()) {
            orgTreeMap.forEach((k, v) -> {
                List tempList1 = (List)orgListMap.get(k);
                tempList1 = tempList1 == null ? new ArrayList() : tempList1;
                orgTreeMap.put((String)k, tempList1);
            });
            orgTreeMap.putAll(orgListMap);
        }
        orgloaclCachversion = OrgUtil.getVersion();
    }

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmDictFeign(MdmOrgRedisFeign orgRedisFeign) {
        mdmOrgRedisFeign = orgRedisFeign;
    }

    @Autowired
    public void setMdmOrgFeign(MdmOrgFeign mdmOrgFeign) {
        OrgUtil.mdmOrgFeign = mdmOrgFeign;
    }

    public static MdmOrgRespVo getOrgByCode(String orgCode) {
        OrgUtil.initOrg();
        MdmOrgRespVo temp = orgMap.get(orgCode);
        if (temp == null) {
            return null;
        }
        MdmOrgRespVo mdmOrgRespVo = new MdmOrgRespVo();
        BeanUtils.copyProperties((Object)temp, (Object)mdmOrgRespVo);
        return mdmOrgRespVo;
    }

    public static MdmOrgRespVo getTopParentOrgByCode(String orgCode) {
        List<MdmOrgRespVo> parentOrgListIncludeSelf;
        if (orgCode != null && !"".equals(orgCode) && (parentOrgListIncludeSelf = OrgUtil.getParentOrgListIncludeSelf(orgCode)) != null && parentOrgListIncludeSelf.size() > 0) {
            for (MdmOrgRespVo item : parentOrgListIncludeSelf) {
                if (item.getLevelNum() != 1 && item.getParentCode() != null && !"".equals(item.getParentCode())) continue;
                MdmOrgRespVo mdmOrgRespVo = new MdmOrgRespVo();
                BeanUtils.copyProperties((Object)item, (Object)mdmOrgRespVo);
                return mdmOrgRespVo;
            }
        }
        return null;
    }

    public static List<MdmOrgRespVo> getOrgByCodeList(List<String> orgCodeList) {
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if (orgCodeList != null && orgCodeList.size() > 0) {
            OrgUtil.initOrg();
            for (String orgCode : orgCodeList) {
                MdmOrgRespVo mdmOrgRespVo = orgMap.get(orgCode);
                if (mdmOrgRespVo == null) continue;
                MdmOrgRespVo temp = new MdmOrgRespVo();
                BeanUtils.copyProperties((Object)mdmOrgRespVo, (Object)temp);
                list.add(temp);
            }
        }
        return list;
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelf(String orgCode) {
        OrgUtil.initOrg();
        ArrayList<MdmOrgRespVo> orgList = new ArrayList<MdmOrgRespVo>();
        MdmOrgRespVo mdmOrgRespVo = orgMap.get(orgCode);
        if (mdmOrgRespVo == null) {
            return orgList;
        }
        MdmOrgRespVo temp = new MdmOrgRespVo();
        BeanUtils.copyProperties((Object)mdmOrgRespVo, (Object)temp);
        orgList.add(temp);
        OrgUtil.getParentOrg(mdmOrgRespVo, orgList);
        return orgList;
    }

    public static void getParentOrg(MdmOrgRespVo mdmOrgRespVo, List<MdmOrgRespVo> orgList) {
        if (mdmOrgRespVo != null && StringUtils.isNotEmpty((CharSequence)mdmOrgRespVo.getParentCode())) {
            MdmOrgRespVo temp = orgMap.get(mdmOrgRespVo.getParentCode());
            if (temp != null) {
                MdmOrgRespVo temp_ = new MdmOrgRespVo();
                BeanUtils.copyProperties((Object)temp, (Object)temp_);
                orgList.add(temp_);
            }
            OrgUtil.getParentOrg(temp, orgList);
        }
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            OrgUtil.initOrg();
            HashMap<String, MdmOrgRespVo> map = new HashMap<String, MdmOrgRespVo>();
            for (String orgCode : orgCodeList) {
                List<MdmOrgRespVo> mdmOrgRespVos = OrgUtil.getParentOrgListIncludeSelf(orgCode);
                for (MdmOrgRespVo tempOrg : mdmOrgRespVos) {
                    map.put(tempOrg.getOrgCode(), tempOrg);
                }
            }
            if (!map.isEmpty()) {
                return new ArrayList<MdmOrgRespVo>(map.values());
            }
        }
        return Collections.emptyList();
    }

    public static Map<String, List<MdmOrgRespVo>> getParentOrgMapIncludeSelf(List<String> orgCodeList) {
        HashMap<String, List<MdmOrgRespVo>> map = new HashMap<String, List<MdmOrgRespVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) {
            OrgUtil.initOrg();
            for (String orgCode : orgCodeList) {
                List<MdmOrgRespVo> mdmOrgRespVos = OrgUtil.getParentOrgListIncludeSelf(orgCode);
                map.put(orgCode, mdmOrgRespVos);
            }
        }
        return map;
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeSelf(String orgCode) {
        if (orgCode != null && !"".equals(orgCode)) {
            OrgUtil.initOrg();
            List<MdmOrgRespVo> parentOrgListIncludeSelf = OrgUtil.getParentOrgListIncludeSelf(orgCode);
            if (parentOrgListIncludeSelf != null && parentOrgListIncludeSelf.size() > 0) {
                return parentOrgListIncludeSelf.stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelf(String orgCode) {
        ArrayList<MdmOrgRespVo> mdmOrgRespVosReturn = new ArrayList<MdmOrgRespVo>();
        if (orgCode != null && !"".equals(orgCode)) {
            OrgUtil.initOrg();
            MdmOrgRespVo mdmOrgRespVo = orgMap.get(orgCode);
            if (mdmOrgRespVo == null) {
                return new ArrayList<MdmOrgRespVo>();
            }
            MdmOrgRespVo temp = new MdmOrgRespVo();
            BeanUtils.copyProperties((Object)mdmOrgRespVo, (Object)temp);
            mdmOrgRespVosReturn.add(temp);
            OrgUtil.getChild(mdmOrgRespVo, mdmOrgRespVosReturn);
        }
        return mdmOrgRespVosReturn;
    }

    private static void getChild(MdmOrgRespVo mdmOrgRespVo, List<MdmOrgRespVo> mdmOrgRespVos) {
        if (mdmOrgRespVo != null || StringUtils.isNotEmpty((CharSequence)mdmOrgRespVo.getOrgCode())) {
            List<MdmOrgRespVo> childOld = orgTreeMap.get(mdmOrgRespVo.getOrgCode());
            ArrayList child = CrmBeanUtil.copyList(childOld, MdmOrgRespVo.class);
            child = child == null ? new ArrayList() : child;
            mdmOrgRespVos.addAll(child);
            if (CollectionUtil.listNotEmptyNotSizeZero(child)) {
                for (MdmOrgRespVo temp : child) {
                    OrgUtil.getChild(temp, mdmOrgRespVos);
                }
            }
        }
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            OrgUtil.initOrg();
            HashMap map = new HashMap();
            for (String orgCode : orgCodeList) {
                List<MdmOrgRespVo> chilrds = OrgUtil.getChildrenOrgListIncludeSelf(orgCode);
                if (!CollectionUtil.listNotEmptyNotSizeZero(chilrds)) continue;
                chilrds.forEach(item -> map.put(item.getOrgCode(), item));
            }
            return new ArrayList<MdmOrgRespVo>(map.values());
        }
        return Collections.emptyList();
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeSelf(String orgCode) {
        if (orgCode != null && !"".equals(orgCode)) {
            OrgUtil.initOrg();
            List<MdmOrgRespVo> parentOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf(orgCode);
            if (parentOrgListIncludeSelf != null && parentOrgListIncludeSelf.size() > 0) {
                return parentOrgListIncludeSelf.stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListExcludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListExcludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListIncludeSelf(String orgCode) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListIncludeSelf(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeSelf(String orgCode) {
        return OrgUtil.getParentOrgListExcludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeSelf(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListExcludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            Map<String, MdmOrgParentChildrenRedisVo> map = OrgUtil.getOrgParentRedisMapFromLocalFirst(orgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String orgCode : orgCodeList) {
                    MdmOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(orgCode) || (redisVo = map.get(orgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmOrgRespVo.class);
                }
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgParentRedisMapFromLocalFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String orgCode : orgCodeList) {
                    if (ThreadLocalUtil.orgParentContains((String)orgCode)) {
                        MdmOrgParentChildrenRedisVo fromOrgParent = ThreadLocalUtil.getFromOrgParent((String)orgCode);
                        if (fromOrgParent == null) continue;
                        map.put(orgCode, fromOrgParent);
                        continue;
                    }
                    getFromRedisCodeSet.add(orgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmOrgParentChildrenRedisVo> mapFromRedisFirst = OrgUtil.getOrgParentRedisMapFromRedisFirst(new ArrayList<String>(orgCodeList));
                    for (String orgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(orgCode)) {
                            map.put(orgCode, mapFromRedisFirst.get(orgCode));
                        }
                        ThreadLocalUtil.addToOrgParent((String)orgCode, (MdmOrgParentChildrenRedisVo)mapFromRedisFirst.get(orgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    public static List<String> getChildrenOrgCodeListIncludeSelf(String orgCode) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListIncludeSelf(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeSelf(String orgCode) {
        return OrgUtil.getChildrenOrgListExcludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeSelf(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            Map<String, MdmOrgParentChildrenRedisVo> map = OrgUtil.getOrgChildrenRedisMapFromLocalFirst(orgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String orgCode : orgCodeList) {
                    MdmOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(orgCode) || (redisVo = map.get(orgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmOrgRespVo.class);
                }
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgChildrenRedisMapFromLocalFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String orgCode : orgCodeList) {
                    if (ThreadLocalUtil.orgChildrenContains((String)orgCode)) {
                        MdmOrgParentChildrenRedisVo fromOrgChildren = ThreadLocalUtil.getFromOrgChildren((String)orgCode);
                        if (fromOrgChildren == null) continue;
                        map.put(orgCode, fromOrgChildren);
                        continue;
                    }
                    getFromRedisCodeSet.add(orgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmOrgParentChildrenRedisVo> mapFromRedisFirst = OrgUtil.getOrgChildrenRedisMapFromRedisFirst(new ArrayList<String>(orgCodeList));
                    for (String orgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(orgCode)) {
                            map.put(orgCode, mapFromRedisFirst.get(orgCode));
                        }
                        ThreadLocalUtil.addToOrgChildren((String)orgCode, (MdmOrgParentChildrenRedisVo)mapFromRedisFirst.get(orgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    public static List<String> getChildrenOrgCodeListExcludeAnySelf(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeAnySelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeAnySelf(List<String> orgCodeList) {
        List<MdmOrgRespVo> parentOrgListExcludeSelf;
        if (orgCodeList != null && orgCodeList.size() > 0 && (parentOrgListExcludeSelf = OrgUtil.getChildrenOrgListExcludeSelf(orgCodeList)) != null && parentOrgListExcludeSelf.size() > 0) {
            HashSet<String> orgCodeSet = new HashSet<String>(orgCodeList);
            return parentOrgListExcludeSelf.stream().filter(item -> !orgCodeSet.contains(item.getOrgCode())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> getParentOrgCodeListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListIncludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListIncludeSelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListExcludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListIncludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListIncludeSelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListExcludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static void deleteAllCache() {
        OrgUtil.setVersion();
        redisService.del(new String[]{"MDM_ORG_LOCK_HASH_0112:"});
        redisService.del(new String[]{"MDM_ORG_SELF_HASH_0112:"});
        redisService.del(new String[]{"MDM_ORG_PARENT_HASH_0112:"});
        redisService.del(new String[]{"MDM_ORG_CHILDREN_HASH_0112:"});
        ThreadLocalUtil.delOrg();
    }

    public static void reloadAllCache() {
        List list;
        OrgUtil.deleteAllCache();
        Result result = mdmOrgRedisFeign.findRedisReloadList();
        if (result.isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
            List partition = Lists.partition((List)list, (int)500);
            for (List item : partition) {
                Map<String, MdmOrgRedisVo> selfMap = item.stream().collect(Collectors.toMap(MdmOrgReloadRedisVo::getOrgCode, MdmOrgReloadRedisVo::getSelf));
                Map<String, List> parentMap = item.stream().collect(Collectors.toMap(MdmOrgReloadRedisVo::getOrgCode, MdmOrgReloadRedisVo::getParentList));
                Map<String, List> childrenMap = item.stream().collect(Collectors.toMap(MdmOrgReloadRedisVo::getOrgCode, MdmOrgReloadRedisVo::getChildrenList));
                redisService.hmset("MDM_ORG_SELF_HASH_0112:", new HashMap<String, MdmOrgRedisVo>(selfMap));
                redisService.hmset("MDM_ORG_PARENT_HASH_0112:", new HashMap<String, List>(parentMap));
                redisService.hmset("MDM_ORG_CHILDREN_HASH_0112:", new HashMap<String, List>(childrenMap));
            }
        }
    }

    private static Map<String, MdmOrgRedisVo> getOrgSelfRedisMapFromRedisFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgRedisVo> map = new HashMap<String, MdmOrgRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List orgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_ORG_LOCK_HASH_0112:", new HashSet<String>(orgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = orgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (orgListFromRedis = redisService.hmget("MDM_ORG_SELF_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && orgListFromRedis.size() > 0 && (collect = orgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmOrgRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmOrgRedisVo::getOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmOrgRedisFeign.findRedisListByOrgCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmOrgRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmOrgRedisVo::getOrgCode, v -> v));
                        HashMap<String, MdmOrgRedisVo> cacheMap = new HashMap<String, MdmOrgRedisVo>(16);
                        for (String orgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(orgCode)) {
                                lockCodeMap.put(orgCode, orgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(orgCode));
                            cacheMap.put(orgCode, collect2.get(orgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_ORG_SELF_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_ORG_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmOrgRedisVo::getOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgParentRedisMapFromRedisFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List orgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_ORG_LOCK_HASH_0112:", new HashSet<String>(orgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = orgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (orgListFromRedis = redisService.hmget("MDM_ORG_PARENT_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && orgListFromRedis.size() > 0 && (collect = orgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmOrgParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmOrgParentChildrenRedisVo::getOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmOrgRedisFeign.findRedisOrgParentListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmOrgParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v));
                        HashMap<String, MdmOrgParentChildrenRedisVo> cacheMap = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
                        for (String orgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(orgCode)) {
                                lockCodeMap.put(orgCode, orgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(orgCode));
                            cacheMap.put(orgCode, collect2.get(orgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_ORG_PARENT_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_ORG_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgChildrenRedisMapFromRedisFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List orgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_ORG_LOCK_HASH_0112:", new HashSet<String>(orgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = orgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (orgListFromRedis = redisService.hmget("MDM_ORG_CHILDREN_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && orgListFromRedis.size() > 0 && (collect = orgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmOrgParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmOrgParentChildrenRedisVo::getOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmOrgRedisFeign.findRedisOrgChildrenListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmOrgParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v));
                        HashMap<String, MdmOrgParentChildrenRedisVo> cacheMap = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
                        for (String orgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(orgCode)) {
                                lockCodeMap.put(orgCode, orgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(orgCode));
                            cacheMap.put(orgCode, collect2.get(orgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_ORG_CHILDREN_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_ORG_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    static {
        orgMap = new ConcurrentHashMap<String, MdmOrgRespVo>();
        orgTreeMap = new ConcurrentHashMap<String, List<MdmOrgRespVo>>();
        orgloaclCach = "mdmloacl:org";
        orgloaclCachversion = "";
    }
}

