package com.biz.crm.base;

import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

@Data
@ApiModel("附件")
public class CrmAttachment {

    @ApiModelProperty("objectName")
    private String objectName;

    @ApiModelProperty("相对路径")
    private String urlPath;

    @ApiModelProperty("域名url")
    private String urlPathPrefix;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("扩展名")
    private String suffix;

    @ApiModelProperty("全路径")
    @Getter(AccessLevel.NONE)
    private String url;

    public String getUrl() {
        if(StringUtils.isBlank(this.url)){
            String urlPath = StringUtils.isBlank(this.objectName) ? this.urlPath : this.objectName;
            return this.urlPathPrefix + urlPath;
        }
        return url;
    }
    public static List<CrmAttachment> convertTaskPic(List<SfaWorkTaskPictureReqVo> visitTaskList){
        if(CollectionUtils.isEmpty(visitTaskList)){
            return Lists.newArrayList();
        }
        return visitTaskList.stream().map(v -> {
            CrmAttachment pic = new CrmAttachment();
            pic.setUrlPathPrefix(v.getPicUrl());
            pic.setUrlPath(v.getPicPath());
            pic.setObjectName(v.getPicDesc());
            pic.setFileName(v.getTitle());
            return pic;
        }).collect(Collectors.toList());
    }


    public static List<CrmAttachment> convertVisitPic(List<SfaVisitPictureRespVo> visitPictureList){
        if(CollectionUtils.isEmpty(visitPictureList)){
            return Lists.newArrayList();
        }
        return visitPictureList.stream().map(v -> {
            CrmAttachment pic = new CrmAttachment();
            pic.setUrlPathPrefix(v.getPicUrl());
            pic.setUrlPath(v.getPicPath());
            pic.setObjectName(v.getPicDesc());
            pic.setFileName(v.getTitle());
            return pic;
        }).collect(Collectors.toList());
    }
}