package com.biz.crm.base;

import com.biz.crm.sqlupdate.CrmColumn;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import java.math.BigDecimal;


/**
 *  @author: luoqi
 *  @Date: 2021-3-22 20:41
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
public class CrmEsDefDocument<T> extends CrmBaseEntity<T>{
    //############################ 字符串 1-15 ###########################
    @CrmColumn(name = "ext1", length = 64)
    private String ext1;
    @CrmColumn(name = "ext2", length = 64)
    private String ext2;
    @CrmColumn(name = "ext3", length = 64)
    private String ext3;
    @CrmColumn(name = "ext4", length = 64)
    private String ext4;
    @CrmColumn(name = "ext5", length = 64)
    private String ext5;
    @CrmColumn(name = "ext6", length = 64)
    private String ext6;
    @CrmColumn(name = "ext7", length = 64)
    private String ext7;
    @CrmColumn(name = "ext8", length = 64)
    private String ext8;
    @CrmColumn(name = "ext9", length = 64)
    private String ext9;
    @CrmColumn(name = "ext10", length = 64)
    private String ext10;
    @CrmColumn(name = "ext11", length = 64)
    private String ext11;
    @CrmColumn(name = "ext12", length = 64)
    private String ext12;
    @CrmColumn(name = "ext13", length = 64)
    private String ext13;
    @CrmColumn(name = "ext14", length = 64)
    private String ext14;
    @CrmColumn(name = "ext15", length = 64)
    private String ext15;

    //############################ 长字符 1-2 ###########################
    @CrmColumn(name = "ext_long_str1", length = 1024)
    private String extLongStr1;
    @CrmColumn(name = "ext_long_str2", length = 1024)
    private String extLongStr2;

    //############################ 长整型数字 1-4 ###########################
    @CrmColumn(name = "ext_long1", mysqlType = "bigint(19)", oracleType = "NUMBER(19,0)")
    private Long extLong1;
    @CrmColumn(name = "ext_long2", mysqlType = "bigint(19)", oracleType = "NUMBER(19,0)")
    private Long extLong2;
    @CrmColumn(name = "ext_long3", mysqlType = "bigint(19)", oracleType = "NUMBER(19,0)")
    private Long extLong3;
    @CrmColumn(name = "ext_long4", mysqlType = "bigint(19)", oracleType = "NUMBER(19,0)")
    private Long extLong4;

    //############################ BigDecimal数字 1-4 ###########################
    @CrmColumn(name = "ext_big_decimal1", mysqlType = "DECIMAL(19,4)", oracleType = "NUMBER(19,4)")
    private BigDecimal extBigDecimal1;
    @CrmColumn(name = "ext_big_decimal2", mysqlType = "DECIMAL(19,4)", oracleType = "NUMBER(19,4)")
    private BigDecimal ext_big_decimal2;
    @CrmColumn(name = "extBigDecimal3", mysqlType = "DECIMAL(19,4)", oracleType = "NUMBER(19,4)")
    private BigDecimal ext_big_decimal3;
    @CrmColumn(name = "ext_big_decimal4", mysqlType = "DECIMAL(19,4)", oracleType = "NUMBER(19,4)")
    private BigDecimal extBigDecimal4;


    //############################ 日期-年 1-4 ###########################
    @CrmColumn(name = "ext_year1", length = 4)
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String extYear1;
    @CrmColumn(name = "ext_year2", length = 4)
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String extYear2;
    @CrmColumn(name = "ext_year3", length = 4)
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String extYear3;
    @CrmColumn(name = "ext_year4", length = 4)
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String extYear4;

    //############################ 日期-年月 1-4 ###########################
    @CrmColumn(name = "ext_year_month1", length = 8)
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String extYearMonth1;
    @CrmColumn(name = "ext_year_month2", length = 8)
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String extYearMonth2;
    @CrmColumn(name = "ext_year_month3", length = 8)
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String extYearMonth3;
    @CrmColumn(name = "ext_year_month4", length = 8)
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String extYearMonth4;


    //############################ 日期 1-4 ###########################
    @CrmColumn(name = "ext_date1", length = 16)
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String extDate1;
    @CrmColumn(name = "ext_date2", length = 16)
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String extDate2;
    @CrmColumn(name = "ext_date3", length = 16)
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String extDate3;
    @CrmColumn(name = "ext_date4", length = 16)
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String extDate4;

    //############################ 日期时间 1-4 ###########################
    @CrmColumn(name = "ext_date_time1", length = 32)
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String extDateTime1;
    @CrmColumn(name = "ext_date_time2", length = 32)
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String extDateTime2;
    @CrmColumn(name = "ext_date_time3", length = 32)
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String extDateTime3;
    @CrmColumn(name = "ext_date_time4", length = 32)
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String extDateTime4;
}
