package com.biz.crm.eunm.activiti;

import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description:  抄送传阅任务类型
 * @Author:: weikangning
 * @Date: 2020/10/13 11:07
 */
public enum ActivityCopyTaskTypeEnum {

  COPY("0","抄送"),
  CIRCULATE("1","传阅"),
  ;

  private String code;
  private String des;

  ActivityCopyTaskTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }
  public String getDes() {
    return des;
  }


  public static String getStatusName(String code){
    ActApproveStatusEnum[] values = ActApproveStatusEnum.values();
    String desc=null;
    for (ActApproveStatusEnum o : values){
      if(StringUtils.equals(o.getCode(),code)){
        desc=o.getDes();
        break;
      }
    }
    return desc;
  }
}
