package com.biz.crm.eunm.kms;

import java.util.HashMap;
import java.util.Map;

import com.google.common.base.Enums;

import lombok.Getter;

/**
 * @Project crm
 * @PackageName com.biz.crm.eunm.kms
 * @ClassName KmsAdminEnum
 * @Author Gavin
 * @Date 2021/4/14 下午4:21
 * @Description kms后台管理数据
 */
public class KmsAdminEnum {

    /**
     * 单据类型
     */
    @Getter
    public enum OrderType {
        LOGIN_ORDER_TYPE("LOGIN_ORDER_TYPE","登录"),
        ORDER("ORDER", "订货单"),
        ACCEPTANCE("ACCEPTANCE", "验收单"),
        RETURN("RETURN", "退货单"),
        PRICE("PRICE", "变价单"),
        SALES_DATA("SALES_DATA", "销售数据"),
        INVENTORY_DATA("INVENTORY_DATA", "库存数据"),
        BILLING_DATA("BILLING_DATA", "结算数据"),
        FEE_DATA("FEE_DATA", "费用数据");

        private String value;
        private String description;

        OrderType(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsAdminEnum.OrderType type : KmsAdminEnum.OrderType.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }

        public static KmsAdminEnum.OrderType getIfPresent(String name) {
            return Enums.getIfPresent(KmsAdminEnum.OrderType.class, name).orNull();
        }
    }

    /**
     * 抓单方式
     */
    @Getter
    public enum AutoType {
        AUTO(1, "自动抓单"),
        MANUAL(0, "手动抓单"),
        IMPORT(2, "手动导入"),
        ;

        private Integer value;
        private String description;

        AutoType(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<Integer, String> GETMAP = new HashMap<>();

        static {
            for (KmsAdminEnum.AutoType type : KmsAdminEnum.AutoType.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 抓单数据类型
     * 0-数据，1-文件
     */
    @Getter
    public enum FileType {
        DATA(0, "数据"),
        FILE(1, "文件"),
        ;

        private Integer value;
        private String description;

        FileType(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<Integer, String> GETMAP = new HashMap<>();

        static {
            for (KmsAdminEnum.FileType type : KmsAdminEnum.FileType.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }

    /**
     * 稽核条件
     */
    @Getter
    public enum AuditCondition {
        ORDER_CODE("ORDER_CODE", "订单编号"),
        GOODS_CODE("GOODS_CODE", "商品编码"),
        STORE_CODE("STORE_CODE", "门店编码"),
        ORDER_TIME("ORDER_TIME", "单据日期"),
        ;

        private String value;
        private String description;

        AuditCondition(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (KmsAdminEnum.AuditCondition type : KmsAdminEnum.AuditCondition.values()) {
                GETMAP.put(type.getValue(), type.getDescription());
            }
        }
    }
}