package com.biz.crm.eunm.kms;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 稽核条件
 * @Author Gavin
 * @Date Created in 2021/6/21 下午5:14
 */
@Getter
public enum KmsAuditConditionEnum {
    /**
     * 两单：日期+门店+SKU
     * 两单：日期+门店
     * 三单：商超订单号+门店+SKU
     * 三单：商超订单号+门店
     */
    PDS("PDS", "商品-日期-门店"),
    DS("DS", "日期-门店"),
    PDSO("PDSO", "商品-门店-订单"),
    SO("SO", "门店-订单"),
    ;

    private String value;
    private String description;

    KmsAuditConditionEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Map<String, String> GETMAP = new HashMap<>();

    static {
        for (KmsAuditConditionEnum type : KmsAuditConditionEnum.values()) {
            GETMAP.put(type.getValue(), type.getDescription());
        }
    }
}
