package com.biz.crm.eunm.mdm;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zxw
 * @date 2021-01-07 13:38
 **/
@AllArgsConstructor
@Getter
public enum MdmPermissionExtensionEnum {

    /**
     * 权限层级
     */
    ALL("0","全部"),
    CURRENT_ORG("1", "当前组织对应的客户"),
    CURRENT_SUB_ORG("2", "当前及下级组织对应的客户"),
    CURRENT_UP_ORG("3", "当前及上级组织对应的客户"),
    SUB_ORG("4", "下级组织对应的客户"),
    CURRENT_POSITION("5", "当前职位对应的客户"),
    CURRENT_SUB_POSITION("6", "当前及下级职位对应的客户"),
    CURRENT_UP_POSITION("7", "当前及上级职位对应的客户"),
    SUB_POSITION("8", "下级职位对应的客户"),
    CURRENT_CUSTOMER("9", "当前客户"),
    DEFAULT("-1", "默认"),;

    private final String code;

    private final String desc;

    public static MdmPermissionExtensionEnum convertEnum(String code) {
        if (code == null || "".equals(code.trim())) {
            return DEFAULT;
        }
        MdmPermissionExtensionEnum[] values = MdmPermissionExtensionEnum.values();
        for (MdmPermissionExtensionEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return DEFAULT;
    }
}
