package com.biz.crm.eunm.sfa;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author hx
 * @ClassName SfaVisitStatisticsTypeEnum
 * @Description
 * @date 2022/03/28
 */
public class SfaVisitStatisticsTypeEnum {

    public enum VisitStatisticsTypeEnum {
        DAY("day", "日拜访"),
        WEEK("week", "周拜访"),
        MONTH("month", "月拜访");

        private String val;
        private String desc;

        VisitStatisticsTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public String getDesc() {
            return desc;
        }

        public static VisitStatisticsTypeEnum getByCode(String val) {
            VisitStatisticsTypeEnum[] values = VisitStatisticsTypeEnum.values();
            Optional<VisitStatisticsTypeEnum> first = Arrays.stream(values).filter(e -> e.getVal().equals(val)).findFirst();
            return !first.isPresent() ? null : first.get();
        }
    }
}
