package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description:crm 活动类型枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum ActTypeEnum {
    PROJECT("project","项目活动"),

    DEPARTMENT_RECEIVE("department_receive","部门领用"),

    PRACTICALITY_CHARGE("practicality_charge","实物费用"),

    DEPARTMENT_CHARGE("department_charge","部门费用"),

    STABLE_CHARGE("stable_charge","定额活动"),

    PROMOTION("promotion","促销活动"),

    REBATE("rebate","返利活动"),

    ;



    private String code;
    private String des;

    ActTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }
    public static String getStatusName(String code){
        ActTypeEnum[] values = ActTypeEnum.values();
        String desc=null;
        for (ActTypeEnum o : values){
            if(StringUtils.equals(o.getCode(),code)){
                desc=o.getDes();
                break;
            }
        }
        return desc;
    }
    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }
}
