package com.biz.crm.util.es.permission;

import com.biz.crm.base.BusinessException;

import java.util.HashMap;


/**
 * ES数据权限注解配置解析器
 *  @author: luoqi
 *  @Date: 2021-5-6 22:59
 *  @version: V1.0
 *  @Description:
 */
public class EsDataPermissionResolver extends HashMap<String, String> {

    public static final String userName = "userName";
    //职位编码
    public static final String position = "position";
    //组织编码
    public static final String org = "org";
    //客户编码
    public static final String customer = "customer";

    public EsDataPermissionResolver(EsDataPermission permission){
        if(null == permission){
            throw new BusinessException("ES数据权限解析异常,权限注解为空！");
        }
        this.put(userName, permission.userName());
        this.put(position, permission.position());
        this.put(org, permission.org());
        this.put(customer, permission.customer());
    }
}
