package com.biz.crm.base;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.util.set.Sets;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.base
 * @ClassName BaseServiceHelper
 * @Author HuangLong
 * @Date 2020/9/21 14:21
 * @Description TODO
 */
@Slf4j
public class BaseServiceHelper {

    public void setPublicParamsNull(CrmBaseEntity entity) {
        entity.setId(null);
        entity.setCreateCode(null);
        entity.setCreateDate(null);
        entity.setCreateDateSecond(null);
        entity.setCreateName(null);
        entity.setCreateOrgCode(null);
        entity.setCreatePosCode(null);
        entity.setCreateOrgName(null);
        entity.setCreatePosName(null);
        entity.setCreateDateAll(null);
        entity.setUpdateDateAll(null);
    }

    public void setPublicParamsNull(CrmBaseVo entity) {
        entity.setId(null);
        entity.setCreateCode(null);
        entity.setCreateDate(null);
        entity.setCreateDateSecond(null);
        entity.setCreateName(null);
        entity.setCreateOrgCode(null);
        entity.setCreatePosCode(null);
        entity.setCreateOrgName(null);
        entity.setCreatePosName(null);
        entity.setCreateDateAll(null);
        entity.setUpdateDateAll(null);
    }

    public List<DictItemVo> convertDictList(Map<String, String> map, String dictJson) {
        if (MapUtils.isEmpty(map)) {
            map = Maps.newHashMap();
        }
        List<String> codes = null;
        try {
            codes = JSON.parseArray(dictJson, String.class);
        } catch (Exception e) {
            log.error("数组json转换数组失败,dictJson={}",dictJson);
        }
        List<DictItemVo> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(codes)) {
            for (String p : codes) {
                String s = map.get(p);
                DictItemVo dictItemVo = new DictItemVo();
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(p);
                list.add(dictItemVo);
            }
        }
        return list;
    }

    /**
     * 判断字符串是否是json数组
     *
     * @param jsonString 待校验的字符串
     * @return Boolean
     */
    public void isJsonArray(String jsonString, String errorMsg) {
        if (StringUtils.isNotEmpty(jsonString)) {
            try {
                List<Object> list = JSON.parseArray(jsonString);
            } catch (Exception e) {
                throw new BusinessException(errorMsg);
            }

        }
    }

    /**
     * 根据字典类型编码和扩展字典编码获取字典值对应的扩展属性值map
     * @param dictTypeCode
     * @param extendDictCode
     * @return
     */
    public Map<String,String> getPayTypeTypeMap(String dictTypeCode,String extendDictCode){
        List<DictDataVo> dataList = DictUtil.list(dictTypeCode);
        return dataList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v.getExtendMap().get(extendDictCode) == null ? "" : v.getExtendMap().get(extendDictCode)));
    }

    /**
     * 获取所有的支付方式map
     * @return
     */
    public Map<String,String> getPayTypesMap(){
        return DictUtil.getDictValueMapsByCodes(TpmGlobalDictConstants.PAY_TYPE);
    }
    public Set<String> dealSelectedCodeList(String selectedCode,Set<String> selectedCodeList){
        if(selectedCodeList==null){
            selectedCodeList= Sets.newHashSet();
        }
        if(StringUtils.isNotEmpty(selectedCode)){
            selectedCodeList.add(selectedCode);
        }
        return selectedCodeList;
    }
}
