package com.biz.crm.config;

import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.IpUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
@Component("ajaxAuthenticationEntryPointExpand")
public class AjaxAuthenticationEntryPointExpand extends AjaxAuthenticationEntryPoint {
    @Value("${oauth2.login.login-url:}")
    private String loginUrl;

    @Override
    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse
            , AuthenticationException e) throws IOException, ServletException {
        String ip = IpUtil.getIpAddrByRequest(HttpServletRequestUtil.getRequest());
        log.warn(httpServletRequest.getRequestURI() + "===>没有登录权限 -> [{}]", ip);
        if(StringUtils.isBlank(this.loginUrl)){
            log.warn("===>没有登录权限 -> 重定向登陆地址为空,调用父类处理逻辑!");
            super.commence(httpServletRequest, httpServletResponse, e);
            return;
        }
//        httpServletResponse.setHeader("Content-type", "text/html;charset=UTF-8");

        httpServletResponse.sendRedirect(loginUrl);
    }
}
