package com.biz.crm.eunm.mdm;

/**
 * 字段分类
 *
 * @author zeyi
 */
public enum PriceSettingFieldEnum {
    /**
     *
     */
    CUSTOMER_CODE("customerCode", "客户"),
    PRODUCT_CODE("productCode", "商品"),
    CHANNEL("channel", "渠道"),
    ORG_CODE("orgCode", "组织"),
    PRICE_GROUP("priceGroup", "价格组"),
    TERMINAL("terminal", "终端"),
    CUSTOMER_TYPE("customerType", "客户类型"),
    TERMINAL_TYPE("terminalType", "终端类型"),
    EXT1("ext1", "扩展字段分类1"),
    EXT2("ext2", "扩展字段分类2"),
    NULL("null", "null");

    private final String code;
    private final String des;

    PriceSettingFieldEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public static PriceSettingFieldEnum match(String code) {
        PriceSettingFieldEnum[] values = values();
        for (PriceSettingFieldEnum priceSettingFieldEnum : values) {
            if (priceSettingFieldEnum.code.equals(code)) {
                return priceSettingFieldEnum;
            }
        }
        return NULL;
    }
}
