package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Project crm
 * @PackageName com.biz.crm.eunm.sfa
 * @ClassName SfaWorkSummaryEnum
 * @Author Gavin
 * @Date 2021/3/5 下午6:27
 * @Description 工作总结枚举
 */
public class SfaWorkSummaryEnum {

    /**
     * 工作总结类型（日报/周报/月报）
     */
    public enum LectureType {
        DAILY("DAILY", "日报"),
        WEEKLY("WEEKLY", "周报"),
        MONTHLY("MONTHLY","月报"),
        EXPERIENCE("EXPERIENCE","分享"),
        ;
        private String val;
        private String desc;

        LectureType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaWorkSummaryEnum.LectureType type : SfaWorkSummaryEnum.LectureType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 权限类型
     */
    public enum ScopeType {
        ALL("ALL", "全部"),
        SELF_SUPERIORS("SELF_SUPERIORS", "自己及上级"),
        ORG_SUBORDINATE("ORG_SUBORDINATE","所在组织及下级"),
        COLLEAGUE("COLLEAGUE","自定义"),
        ;
        private String val;
        private String desc;

        ScopeType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaWorkSummaryEnum.ScopeType type : SfaWorkSummaryEnum.ScopeType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 是否转发
     */
    public enum IsForward {
        Y("Y", "转发"),
        N("N", "总结"),
        ;
        private String val;
        private String desc;

        IsForward(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaWorkSummaryEnum.IsForward type : SfaWorkSummaryEnum.IsForward.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 查询类型（艾特/评论）
     */
    public enum QueryType {
        AT("AT", "@我的"),
        COMMENT("COMMENT", "我评论的"),
        SELF("SELF", "自己"),
        POSITION("POSITION", "直属职位"),
        ;
        private String val;
        private String desc;

        QueryType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaWorkSummaryEnum.QueryType type : SfaWorkSummaryEnum.QueryType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}