package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * webservice xml javabean
 *
 * @Author wei·yang
 * @Date Created in 2020-04-22 10:47
 */
@Slf4j
public class XmlBeanUtil {

    /**
     * javabean 转 xml
     * @param obj
     * @param encoding
     * @return
     */
    @SuppressWarnings("unchecked")
    public static String beanToXml(Object obj, String encoding){
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(obj.getClass());
            StringWriter writer = new StringWriter();
            //创建marshaller 接口对象 实现BEAN--->xml转换
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.FALSE);
            if (StringUtils.isNotBlank(encoding)) {
                marshaller.setProperty(Marshaller.JAXB_ENCODING, encoding);
            }
            marshaller.marshal(obj, writer);
            return writer.toString();
        } catch (JAXBException e) {
            log.error("marshaller Bean-->Xml error:", e);
            throw new BusinessException("对象转xml异常!");
        }
    }

    /**
     * xml 转 bean
     * @param xml
     * @param t
     * @param <T>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> T xmlToBean(String xml,Class<T> t){
        try {
            JAXBContext context = JAXBContext.newInstance(t);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T) unmarshaller.unmarshal(new StringReader(xml));
        } catch (JAXBException e) {
            log.error("Xml -> marshaller Bean error:", e);
            throw new BusinessException("XML转换对象失败!");
        }
    }
}
