package com.biz.crm.complaints.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_complaints_content")
@CrmTable(name = "dms_complaints_content",tableNote = "投诉建议内容")
public class ComplaintsContentEntity extends CrmExtTenEntity<ComplaintsContentEntity> {

    /**
     * 投诉id
     */
    @CrmColumn(name = "complaints_id", length = 64)
    private String complaintsId;

    /**
     * 内容
     */
    @CrmColumn(name = "content", length = 200)
    private String content;

    /**
     * 回复人类型
     */
    @CrmColumn(name = "submitter_type")
    private String submitterType;

}
