package com.biz.crm.complaints.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_complaints")
@CrmTable(name = "dms_complaints",tableNote = "投诉建议")
public class ComplaintsEntity extends CrmExtTenEntity<ComplaintsEntity> {

    /**
     * 投诉单号
     */
    @CrmColumn(name = "complaints_no", length = 64)
    private String complaintsNo;

    /**
     * 投诉标题
     */
    @CrmColumn(name = "complaints_title", length = 64)
    private String complaintsTitle;

    /**
     * 投诉类型：
     * {@link com.biz.crm.eunm.dms.ComplaintsEunm.ComplaintsTypeEnum}
     */
    @CrmColumn(name = "complaints_type")
    private String complaintsType;

    /**
     * 投诉状态
     * {@link com.biz.crm.eunm.dms.ComplaintsEunm.ComplaintsStatusEnum}
     */
    @CrmColumn(name = "complaints_status")
    private String complaintsStatus;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name" , length = 128)
    private String customerName;


}
