package com.biz.crm.companyinformation.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.companyinformation.service.CompanyInformationService;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-公司资料", tags = "管理端-公司资料")
@RestController
@RequestMapping("/m/companyInformation")
public class CompanyInformationmController {

    @Resource
    private CompanyInformationService companyInformationService;

    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody CompanyInformationVo companyInformationVo) {
        companyInformationService.add(companyInformationVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑")
    @PostMapping(value = "edit")
    public Result edit(@RequestBody CompanyInformationVo companyInformationVo) {
        companyInformationService.edit(companyInformationVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "通过id查询")
    @GetMapping(value = "findById/{id}")
    public Result<CompanyInformationVo> findById(@PathVariable("id") String id) {
        return Result.ok(companyInformationService.findById(id));
    }


    @CrmLog
    @ApiOperation(value = "分页搜索公司资料")
    @PostMapping(value = "list")
    public Result<PageResult<CompanyInformationVo>> list(@RequestBody CompanyInformationVo companyInformationVo) {
        return Result.ok(companyInformationService.list(companyInformationVo, null));
    }

    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
        companyInformationService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "根据查询条件批量删除")
    @PostMapping(value = "delByParam")
    public Result<Object> delByParam(@RequestBody CompanyInformationVo companyInformationVo) {
        companyInformationService.delByParam(companyInformationVo);
        return Result.ok();
    }
}
