package com.biz.crm.companyinformation.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * @Description:公司资料范围表,限定资料查看范围
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:46
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_company_information_area")
@CrmTable(name = "dms_company_information_area", indexes = {
        @Index(name = "company_information_area_id", columnList = "information_id")
},tableNote = "公司资料范围表")
public class CompanyInformationAreaEntity extends CrmExtEntity<CompanyInformationAreaEntity> {


    /**
     * 公司资料id
     */
    @CrmColumn(name = "information_id", length = 64)
    private String informationId;

    /**
     * 组织code
     */
    @CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 100)
    private String orgName;

    /**
     * 客户code
     */
    @CrmColumn(name = "cus_code", length = 64)
    private String cusCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "cus_name", length = 100)
    private String cusName;

    /**
     * 是否包含
     */
    @CrmColumn(name = "contain_flag")
    private Integer containFlag;

    /**
     * 包含是否被抵消
     */
    @CrmColumn(name = "offset_flag")
    private Integer offsetFlag;

}
