package com.biz.crm.companyinformation.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;


import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 公司资料主表
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:46
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_company_information")
@CrmTable(name = "dms_company_information",tableNote = "公司资料主表")
public class CompanyInformationEntity extends CrmExtEntity<CompanyInformationEntity> {

    /**
     * 资料名称
     */
    @CrmColumn(name = "name", length = 100)
    private String name;


    /**
     * 资料类型
     */
    @CrmColumn(name = "type")
    private Integer type;
}
