package com.biz.crm.companyinformation.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmFileEntity;


import javax.persistence.Index;

import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:公司资料文件表
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:46
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_company_information_file")
@CrmTable(name = "dms_company_information_file", indexes = {
        @Index(name = "company_information_file_id", columnList = "information_id")
},tableNote = "公司资料文件表")
public class CompanyInformationFileEntity extends CrmFileEntity<CompanyInformationFileEntity> {


    /**
     * 公司资料id
     */
    @CrmColumn(name = "information_id")
    private String informationId;

    /**
     * 文件显示顺序
     */
    @CrmColumn(name = "sort_num")
    private Integer sortNum;

}
