package com.biz.crm.companyinformation.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.companyinformation.entity.CompanyInformationAreaEntity;
import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.companyinformation.mapper.CompanyInformationAreaMapper;
import com.biz.crm.companyinformation.service.CompanyInformationAreaService;
import com.biz.crm.companyinformation.utils.CompanyInformationAreaUtil;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationAreaVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:42
 **/
@ConditionalOnMissingBean(name = "companyInformationAreaServiceExpandImpl")
@Service(value = "companyInformationAreaService")
public class CompanyInformationAreaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<CompanyInformationAreaMapper, CompanyInformationAreaEntity>
        implements CompanyInformationAreaService {

    @Autowired
    private CompanyInformationAreaMapper companyInformationAreaMapper;

    /**
     * 1、先删除对应公司资料的范围
     * 2、组装
     * 3、保存
     * @param companyInformationEntity
     * @param areaVos
     */
    @Transactional
    @Override
    public void replace(CompanyInformationEntity companyInformationEntity, List<CompanyInformationAreaVo> areaVos) {
        //1
        this.removeByMap(new HashMap<String, Object>(){{
            put("information_id",companyInformationEntity.getId());
        }});
        //如果没有区域，则代表适应所有的区域
        if(CollectionUtils.isEmpty(areaVos)){
            return;
        }

        //2
        List<CompanyInformationAreaEntity> entities = new ArrayList<>();
        for(CompanyInformationAreaVo vo:areaVos){
            CompanyInformationAreaEntity entity = new CompanyInformationAreaEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setInformationId(companyInformationEntity.getId());
            entities.add(entity);
        }
        entities = CompanyInformationAreaUtil.judegeOffsetFlag(entities);

        //3
        this.saveBatch(entities);
    }

    /**
     * 1、验证
     * 2、查询并且组装返回
     * @param informationId
     * @return
     */
    @Override
    public List<CompanyInformationAreaVo> findByInformationId(String informationId) {
        //1
        if(StringUtils.isEmpty(informationId)){
            return new ArrayList<>();
        }

        //2
        QueryWrapper<CompanyInformationAreaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("information_id", informationId);
        List<CompanyInformationAreaEntity> areaEntities = companyInformationAreaMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(areaEntities)){
            return new ArrayList<>();
        }
        List<CompanyInformationAreaVo> reList = new ArrayList<>(areaEntities.size());
        for(CompanyInformationAreaEntity entity : areaEntities){
            CompanyInformationAreaVo vo = new CompanyInformationAreaVo();
            BeanUtils.copyProperties(entity,vo);
            reList.add(vo);
        }
        return reList;
    }


    @Override
    @Transactional
    public void delByInformationIds(List<String> informationIds) {
        if(CollectionUtils.isEmpty(informationIds)){
            throw new BusinessException("公司资料id为空");
        }
        QueryWrapper<CompanyInformationAreaEntity> wrapper = new QueryWrapper<>();
        wrapper.in("information_id", informationIds);
        companyInformationAreaMapper.delete(wrapper);
    }
}
