package com.biz.crm.companyinformation.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.companyinformation.entity.CompanyInformationFileEntity;
import com.biz.crm.companyinformation.mapper.CompanyInformationFileMapper;
import com.biz.crm.companyinformation.service.CompanyInformationFileService;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationFileVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:42
 **/
@ConditionalOnMissingBean(name = "companyInformationFileServiceExpandImpl")
@Service(value = "companyInformationFileService")
public class CompanyInformationFileServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<CompanyInformationFileMapper, CompanyInformationFileEntity>
        implements CompanyInformationFileService {

    @Autowired
    private CompanyInformationFileMapper companyInformationFileMapper;

    /**
     * 1、先删除公司资料下的所有文件
     * 2、组装
     * 3、保存
     * @param companyInformationEntity
     * @param files
     */
    @Transactional
    @Override
    public void replace(CompanyInformationEntity companyInformationEntity, List<CompanyInformationFileVo> files) {
        //1
        this.removeByMap(new HashMap<String, Object>(){{
            put("information_id",companyInformationEntity.getId());
        }});
        if(CollectionUtils.isEmpty(files)){
            return;
        }

        //2
        List<CompanyInformationFileEntity> entities = new ArrayList<>(files.size());
        int i = 0;
        for(CompanyInformationFileVo vo : files){
            i ++ ;
            vo.setSortNum(i);
            CompanyInformationFileEntity entity = new CompanyInformationFileEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setInformationId(companyInformationEntity.getId());
            entities.add(entity);
        }

        //3
        this.saveBatch(entities);
    }

    /**
     * 1、验证
     * 2、查询并且组装返回
     * @param informationId
     * @return
     */
    @Override
    public List<CompanyInformationFileVo> findByInformationId(String informationId) {
        //1
        if(StringUtils.isEmpty(informationId)){
            return new ArrayList<>();
        }

        //2
        QueryWrapper<CompanyInformationFileEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("information_id", informationId);
        List<CompanyInformationFileEntity> fileEntities = companyInformationFileMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(fileEntities)){
            return new ArrayList<>();
        }
        List<CompanyInformationFileVo> reList = new ArrayList<>(fileEntities.size());
        for(CompanyInformationFileEntity entity : fileEntities){
            CompanyInformationFileVo vo = new CompanyInformationFileVo();
            BeanUtils.copyProperties(entity,vo);
            reList.add(vo);
        }
        Collections.sort(reList,(a, b)->a.getSortNum().compareTo(b.getSortNum()));
        return reList;
    }

    /**
     * 1、验证
     * 2、查询并且组装
     * 3、排序并返回
     * @param informationIds
     * @return
     */
    @Override
    public Map<String, List<CompanyInformationFileVo>> findByInformationIds(List<String> informationIds) {
        //1
        Map<String, List<CompanyInformationFileVo>> reMap = new HashMap<>();
        if(CollectionUtils.isEmpty(informationIds)){
            return reMap;
        }

        //2
        QueryWrapper<CompanyInformationFileEntity> wrapper = new QueryWrapper<>();
        wrapper.in("information_id", informationIds);
        List<CompanyInformationFileEntity> fileEntities = companyInformationFileMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(fileEntities)){
            return reMap;
        }
        reMap = fileEntities.stream()
                .map(entity->{
                    CompanyInformationFileVo vo = new CompanyInformationFileVo();
                    BeanUtils.copyProperties(entity, vo);
                    return vo;
                })
                .collect(Collectors.groupingBy(CompanyInformationFileVo::getInformationId));

        //3
        for(String informationId : reMap.keySet()){
            Collections.sort(reMap.get(informationId), (a,b)->a.getSortNum().compareTo(b.getSortNum()));
        }
        return reMap;
    }

    @Override
    @Transactional
    public void delByInformationIds(List<String> informationIds) {
        if(CollectionUtils.isEmpty(informationIds)){
            throw new BusinessException("公司资料id为空");
        }
        QueryWrapper<CompanyInformationFileEntity> wrapper = new QueryWrapper<>();
        wrapper.in("information_id", informationIds);
        companyInformationFileMapper.delete(wrapper);
    }
}
