package com.biz.crm.complaints.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.complaints.service.ComplaintsService;
import com.biz.crm.eunm.dms.ComplaintsEunm;
import com.biz.crm.nebular.dms.complaints.ComplaintsReplyVo;
import com.biz.crm.nebular.dms.complaints.ComplaintsRes;
import com.biz.crm.nebular.dms.complaints.ComplaintsVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/18
 */
@Api(value = "管理端-投诉建议", tags = "管理端-投诉建议")
@RestController
@RequestMapping("/m/complaints")
public class ComplaintsmController {

    @Resource
    private ComplaintsService complaintsService;

    @CrmLog
    @ApiOperation(value = "投诉建议处理")
    @PostMapping(value = "mReply")
    public Result mReply(@RequestBody ComplaintsReplyVo complaintsReplyVo) {
        String flag = String.valueOf(ComplaintsEunm.ComplaintsStatusEnum.CUSTOMER.getCode());
        complaintsService.replyComplaints(complaintsReplyVo,flag);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "m端分页列表")
    @PostMapping(value = "mList")
    public Result<PageResult<ComplaintsVo>> mList(@RequestBody ComplaintsVo complaintsVo) {
        PageResult<ComplaintsVo> complaintsVoPageResult = complaintsService.list(complaintsVo);
        return Result.ok(complaintsVoPageResult);
    }

    @CrmLog
    @ApiOperation(value = "m端投诉建议详情")
    @GetMapping(value = "mDetailById/{id}")
    public Result<ComplaintsRes> mDetailById(@PathVariable("id") String id){
        String flag = ComplaintsEunm.ComplaintsStatusEnum.FACTORY.getValue();
        return Result.ok(complaintsService.detailById(id,flag));
    }

}
