package com.biz.crm.complaints.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.complaints.service.ComplaintsService;
import com.biz.crm.eunm.dms.ComplaintsEunm;
import com.biz.crm.nebular.dms.complaints.ComplaintsReplyVo;
import com.biz.crm.nebular.dms.complaints.ComplaintsRes;
import com.biz.crm.nebular.dms.complaints.ComplaintsVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/18
 */
@Api(value = "移动端-投诉建议", tags = "移动端-投诉建议")
@RestController
@RequestMapping("/v/complaints")
public class ComplaintsvController {

    @Resource
    private ComplaintsService complaintsService;

    @CrmLog
    @ApiOperation(value = "投诉建议新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody ComplaintsVo complaintsVo) {
        complaintsService.add(complaintsVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "投诉建议回复")
    @PostMapping(value = "pReply")
    public Result pReply(@RequestBody ComplaintsReplyVo complaintsReplyVo) {
        String flag = String.valueOf(ComplaintsEunm.ComplaintsStatusEnum.FACTORY.getCode());
        complaintsService.replyComplaints(complaintsReplyVo,flag);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "投诉建议(解决)")
    @PostMapping(value = "solve")
    public Result solve(@RequestParam String id) {
        complaintsService.solveComplaints(id);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "p端分页列表")
    @PostMapping(value = "pList")
    public Result<PageResult<ComplaintsVo>> plist(@RequestBody ComplaintsVo complaintsVo) {
        UserRedis userRedis = UserUtils.getUser();
        complaintsVo.setCreateCode(userRedis.getCustcode());
        PageResult<ComplaintsVo> complaintsVoPageResult = complaintsService.list(complaintsVo);
        return Result.ok(complaintsVoPageResult);
    }

    @CrmLog
    @ApiOperation(value = "p端投诉建议详情")
    @GetMapping(value = "pDetailById/{id}")
    public Result<ComplaintsRes> mDetailById(@PathVariable("id") String id){
        String flag = ComplaintsEunm.ComplaintsStatusEnum.CUSTOMER.getValue();
        ComplaintsRes complaintsRes = complaintsService.detailById(id, flag);
        return Result.ok(complaintsRes);
    }

}
