package com.biz.crm.complaints.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.complaints.entity.ComplaintsEntity;
import com.biz.crm.complaints.entity.ComplaintsFileEntity;
import com.biz.crm.complaints.mapper.ComplaintsFileMapper;
import com.biz.crm.complaints.service.ComplaintsFileService;
import com.biz.crm.nebular.dms.complaints.ComplaintsFileVo;
import com.biz.crm.nebular.dms.notice.NoticeFileVo;
import com.biz.crm.notice.entity.NoticeFileEntity;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 投诉附件类
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/18
 */
@ConditionalOnMissingBean(name = "complaintsFileServiceExpandImpl")
@Service(value = "complaintsFileService")
public class ComplaintsFileServiceImpl<M extends BaseMapper<T>,T>
        extends ServiceImpl<ComplaintsFileMapper, ComplaintsFileEntity>
        implements ComplaintsFileService {

    @Resource
    private ComplaintsFileMapper complaintsFileMapper;

    /**
     * 1.为空返回
     * 2.组装
     * 3.保存
     *
     * @param entity
     * @param files
     */
    @Transactional
    @Override
    public void add(ComplaintsEntity entity, List<ComplaintsFileVo> files) {
        //1
        if(CollectionUtils.isEmpty(files)){
            return;
        }
        //2
        List<ComplaintsFileEntity> entities = new ArrayList<>(files.size());

        int i = 0;
        for(ComplaintsFileVo vo : files){
            i ++ ;
            vo.setSortNum(i);
            ComplaintsFileEntity fileEntity = new ComplaintsFileEntity();
            BeanUtils.copyProperties(vo,fileEntity);
            fileEntity.setComplaintsId(entity.getId());
            entities.add(fileEntity);
        }
        //3
        this.saveBatch(entities);

    }

    /**
     * 1.根据投诉建议id查询文件列表
     * 2.组装返回
     * @param id
     * @return
     */
    @Override
    public List<ComplaintsFileVo> filesById(String id) {

        //1
        List<ComplaintsFileEntity> complaintsFiles= complaintsFileMapper.selectList(
                new QueryWrapper<ComplaintsFileEntity>().eq("complaints_id", id).orderByAsc("create_date_all")
        );

        //2
        ArrayList<ComplaintsFileVo> complaintsFileVos = new ArrayList<>();
        for (ComplaintsFileEntity complaintsFile : complaintsFiles) {
            ComplaintsFileVo complaintsFileVo = new ComplaintsFileVo();
            BeanUtils.copyProperties(complaintsFile,complaintsFileVo);
            complaintsFileVos.add(complaintsFileVo);
        }
        return complaintsFileVos;
    }
}
