package com.biz.crm.contract.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.contract.service.ContractService;
import com.biz.crm.nebular.dms.contract.ContractVo;
import com.biz.crm.nebular.dms.contract.UpdateEndTimeByIdsReq;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Api(value = "管理端-合同", tags = "管理端-合同")
@RestController
@RequestMapping("/m/contract")
public class ContractmController {

    @Resource
    private ContractService contractService;

    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody ContractVo contractVo){
        contractService.add(contractVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "修改")
    @PostMapping(value = "edit")
    public Result edit(@RequestBody ContractVo contractVo){
        contractService.edit(contractVo);
        return Result.ok("编辑用户信息保存成功");
    }

    @CrmLog
    @ApiOperation(value = "通过id查询")
    @GetMapping(value = "findById/{id}")
    public Result findById(@PathVariable("id") String id){
        return Result.ok(contractService.findById(id));
    }

    @CrmLog
    @ApiOperation(value = "分页搜索合同")
    @PostMapping(value = "list")
    public Result<PageResult<ContractVo>> list(@RequestBody ContractVo contractVo) {
        return Result.ok(contractService.list(contractVo));
    }

    @CrmLog
    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
        contractService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "根据查询条件批量删除")
    @PostMapping(value = "delByParam")
    public Result<Object> delByParam(@RequestBody ContractVo contractVo) {
        contractService.delByParam(contractVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "条件查询合同列表")
    @PostMapping(value = "findByConditions")
    public Result<List<ContractVo>> findByConditions(@RequestBody ContractVo contractVo) {
        return Result.ok(contractService.findByConditions(contractVo));
    }


    @CrmLog
    @ApiOperation(value = "根据id批量修改结束时间")
    @PostMapping(value = "updateEndTimeByIds")
    public Result<Object> updateEndTimeByIds(@RequestBody UpdateEndTimeByIdsReq updateEndTimeByIdsReq) {
        contractService.updateEndTimeByIds(updateEndTimeByIdsReq);
        return Result.ok();
    }
}
