package com.biz.crm.contract.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.config.CrmDict;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 合同主表
 * @Author: heyijiang
 * @Date: 2020/9/15 11:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_contract")
public class ContractEntity extends CrmExtEntity<ContractEntity> {

    /**
     * 合同类型
     */
    private Integer type;

    /**
     * 合同年度，仅包含年份
     */
    private Integer year;

    /**
     * 合同编号
     */
    private String code;

    /**
     * 客户编码
     */
    private String cusCode;

    /**
     * 客户名称
     */
    private String cusName;

    /**
     * 销售公司编码
     */
    private String saleCompanyCode;

    /**
     * 对接人编码
     */
    private String dockingCode;

    /**
     * 对接人名称
     */
    private String dockingName;

    /**
     * 客户法人代表
     */
    private String legalRepresent;

    /**
     * 客户联系方式
     */
    private String cusPhone;

    /**
     * 客户渠道类型编码
     */
    private String cusChannelCode;

    /**
     * 客户所属组织编码
     */
    private String cusOrgCode;

    /**
     * 客户所属组织名称
     */
    private String cusOrgName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 省
     */
    private String province;


    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 市
     */
    private String city;

    /**
     * 区县编码
     */
    private String districtCode;

    /**
     * 区县
     */
    private String district;

    /**
     * 合同有效开始时间，格式 yyyy-MM-dd
     */
    private String startTime;

    /**
     * 合同有效截止时间，格式 yyyy-MM-dd
     */
    private String endTime;

    /**
     * 合同展示是否隐藏销售范围标志
     */
    private Integer areasHideFlag;
}
