package com.biz.crm.contract.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.nebular.dms.contract.ContractVo;
import com.biz.crm.nebular.dms.contract.UpdateEndTimeByIdsReq;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: heyijiang
 * @Date: 2020/9/15 13:42
 */
public interface ContractMapper extends BaseMapper<ContractEntity> {

    /**
     * 分页查询
     * @param page
     * @param wrapper
     * @return
     */
    List<ContractVo> list(Page page, @Param("ew") QueryWrapper<ContractVo> wrapper);

  /**
   * 条件查询列表
   * @param wrapper
   * @return
   */
    List<ContractVo> findByConditions(@Param("ew") QueryWrapper<ContractVo> wrapper);

    /**
     * 根据id批量修改结束时间
     * @param updateEndTimeByIdsReq
     */
    void updateEndTimeByIds(@Param("updateEndTimeByIdsReq") UpdateEndTimeByIdsReq updateEndTimeByIdsReq);
}
