package com.biz.crm.contract.service;

import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.nebular.dms.contract.ContractSalesAreaVo;

import java.util.List;
import java.util.Map;

/**
 * @Author: heyijiang
 * @Date: 2020/11/4 10:50
 */
public interface ContractSalesAreaService {

    /**
     * 批量添加销售范围
     * @param contractEntity
     * @param salesAreas
     */
    void replace(ContractEntity contractEntity, List<ContractSalesAreaVo> salesAreas,List<ContractSalesAreaVo> salesAreasNoContain);

    /**
     * 根据合同id查询销售范围
     * @param contractId
     * @return key:
     *          contain:包含
     *          noContain:非包含
     *         value:
     *          不为空
     */
     Map<String,List<ContractSalesAreaVo>> findByContractId(String contractId);

    /**
     * 根据合同ids删除销售范围
     * @param contractIds
     * @return
     */
    void delByContractIds(List<String> contractIds);
}
