package com.biz.crm.contract.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.contract.ContractVo;
import com.biz.crm.nebular.dms.contract.UpdateEndTimeByIdsReq;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: heyijiang
 * @Date: 2020/9/16 10:25
 */
public interface ContractService {
    /**
     * 新增
     * @param contractVo
     */
    void add(ContractVo contractVo);

    /**
     * 编辑
     * @param contractVo
     */
    void edit(ContractVo contractVo);

    /**
     * 通过id查询对象
     * @param id
     * @return
     */
    ContractVo findById(String id);

    /**
     * 分页搜索
     * @param contractVo
     * @return
     */
    PageResult<ContractVo> list(ContractVo contractVo);

    /**
     * 根据id批量删除
     * @param ids
     */
    void delByIds(ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     * @param contractVo
     */
    void delByParam(ContractVo contractVo);

    /**
     * 条件查询合同列表
     * @param contractVo
     * @return
     */
    List<ContractVo> findByConditions(ContractVo contractVo);

    /**
     * 根据id批量修改结束时间
     * @param updateEndTimeByIdsReq
     */
    void updateEndTimeByIds(UpdateEndTimeByIdsReq updateEndTimeByIdsReq);
}
